/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Locale;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.i18n.Translatrix;


/**
 * represents a JPanel with a JComponent and an JLabel located over it to
 * describe it. can be used to add JTextFields, etc. with their description to
 * a form
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: NamedComponentVariable.java,v $
 * <br>Revision 1.10  2010-11-26 13:16:39  ferring
 * <br>the NamedComponent will add a space before the ':', if the local is French
 * <br>
 * <br>Revision 1.9  2010-03-23 15:05:37  troth
 * <br>add new constructor with color
 * <br>
 * <br>Revision 1.8  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.6  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class NamedComponentVariable extends JPanel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
    private static final int vTextAlignment = JLabel.LEFT;
    private static final int hTextAlignment = JLabel.BOTTOM;
    private static final int preferedHeight = 22;

    //~ Instance fields ========================================================

    private JComponent component;
    private JLabel nameLabel;

    //~ Constructors ===========================================================
    /**
     * generates a JPanel with a JComponent and an JLabel located over it to
     * describe it.
     *
     * @param name The Text of the shown Label
     * @param component The JComponent shown under the Label
     */
    public NamedComponentVariable(String name, JComponent component)
    {
    	this(name, null, component, null);
//        this.setLayout(new BorderLayout());
//        nameLabel = new JLabel(name + 
//    			// add a space, if local is France
//    			(Translatrix.getLocale().equals(Locale.FRANCE) ? " :" : ":"));
//        nameLabel.setHorizontalAlignment(vTextAlignment);
//        nameLabel.setVerticalAlignment(hTextAlignment);
//        nameLabel.setPreferredSize(new Dimension(0, preferedHeight));
//        this.component = component;
//        nameLabel.setOpaque(false);
//        this.setOpaque(false);
//        
//        this.add(this.nameLabel, BorderLayout.NORTH);
//        this.add(this.component, BorderLayout.CENTER);
    }
    
    /**
     * generates a JPanel with a JComponent and an JLabel located over it to
     * describe it.
     *
     * @param name The Text of the shown Label
     * @param component The JComponent shown under the Label
     */
    public NamedComponentVariable(String name, Color textColor, JComponent component)
    {
    	this(name, textColor, component, null);
//        this.setLayout(new BorderLayout());
//        nameLabel = new JLabel(name + 
//    			// add a space, if local is France
//    			(Translatrix.getLocale().equals(Locale.FRANCE) ? " :" : ":"));
//        nameLabel.setForeground(textColor);
//        nameLabel.setHorizontalAlignment(vTextAlignment);
//        nameLabel.setVerticalAlignment(hTextAlignment);
//        nameLabel.setPreferredSize(new Dimension(0, preferedHeight));
//        this.component = component;
//        nameLabel.setOpaque(false);
//        this.setOpaque(false);
//        
//        this.add(this.nameLabel, BorderLayout.NORTH);
//        this.add(this.component, BorderLayout.CENTER);
    }
    
    
    /**
     * generates a JPanel with a JComponent and an JLabel located over it to
     * describe it.
     *
     * @param name The Text of the shown Label
     * @param component The JComponent shown under the Label
     */
    public NamedComponentVariable(String name, JComponent component, JButton b)
    {
    	this(name, null, component, b);
//        this.setLayout(new BorderLayout());
//        nameLabel = new JLabel(name + 
//    			// add a space, if local is France
//    			(Translatrix.getLocale().equals(Locale.FRANCE) ? " :" : ":"));
//        nameLabel.setHorizontalAlignment(vTextAlignment);
//        nameLabel.setVerticalAlignment(hTextAlignment);
//        nameLabel.setPreferredSize(new Dimension(0, preferedHeight));
//        
//        JPanel jp = new JPanel(new BorderLayout(2,2));
//        jp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
//        jp.setOpaque(false);
//        jp.add(nameLabel, BorderLayout.CENTER);
//        if (b != null)
//        	jp.add(b, BorderLayout.EAST);
//        
//        this.component = component;
//        nameLabel.setOpaque(false);
//        this.setOpaque(false);
//        
//        this.add(jp, BorderLayout.NORTH);
//        this.add(this.component, BorderLayout.CENTER);
    }
    
    /**
     * generates a JPanel with a JComponent and an JLabel located over it to
     * describe it.
     *
     * @param name The Text of the shown Label
     * @param component The JComponent shown under the Label
     */
    public NamedComponentVariable(String name, Color textColor, JComponent component, JButton b)
    {
        this.setLayout(new BorderLayout());
        nameLabel = new JLabel(name + 
    			// add a space, if local is France
    			(Translatrix.getLocale().equals(Locale.FRANCE) ? " :" : ":"));
        if (textColor != null)
        	nameLabel.setForeground(textColor);
        nameLabel.setHorizontalAlignment(vTextAlignment);
        nameLabel.setVerticalAlignment(hTextAlignment);
        nameLabel.setPreferredSize(new Dimension(0, preferedHeight));
        
        JPanel jp = new JPanel(new BorderLayout(2,2));
        jp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        jp.setOpaque(false);
        jp.add(nameLabel, BorderLayout.CENTER);
        if (b != null)
        	jp.add(b, BorderLayout.EAST);
        
        this.component = component;
        nameLabel.setOpaque(false);
        this.setOpaque(false);
        
        this.add(jp, BorderLayout.NORTH);
        this.add(this.component, BorderLayout.CENTER);
    }
}
