/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;


/**
 * This Class implements a JTextfield that only allows numbers to be
 * inserted.
 * examples: 12
 * 			 23.5
 *

 * @author martin.heinemann@tudor.lu
 * 20.03.2008
 * 10:36:39
 *
 *
 * @version
 * <br>$Log: NumberField.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class NumberField extends JTextField
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
    
    private static final Pattern	DECIMAL_PATTERN	= Pattern.compile("^(\\d*?)([,.]\\d*)?$");
    private static final Pattern	INTEGER_PATTERN	= Pattern.compile("^\\d*$");
    
    private static final Pattern	DECIMAL_PATTERN_NEGATIVE	= Pattern.compile("^-?(\\d*?)([,.]\\d*)?$");
    private static final Pattern	INTEGER_PATTERN_NEGATIVE	= Pattern.compile("^-?\\d*$");


    //~ Instance fields ========================================================

    private Matcher m;
	private int limit = 30;
	private Pattern p = DECIMAL_PATTERN;

    //~ Constructors ===========================================================
    /**
     */
    public NumberField()
    {
        super();
        this.init();
    }

    /**
     */
    public NumberField(int limit)
    {
        super();
        this.limit = limit;
        this.init();
    }

    
    
    public NumberField (int limit, boolean useDecimalPattern)
    {
    	this(limit, useDecimalPattern, false);
    }
    
    public NumberField (int limit, boolean useDecimalPattern, boolean allowNegative)
    {
    	this(limit);
    	if (allowNegative) {
    		if (useDecimalPattern)
    			p = DECIMAL_PATTERN_NEGATIVE;
    		else
    			p = INTEGER_PATTERN_NEGATIVE;
    	} else {
    		if (useDecimalPattern)
    			p = DECIMAL_PATTERN;
    		else
    			p = INTEGER_PATTERN;
    	}
    	
    }

    
    //~ Methods ================================================================
    /**
     * do initial settings
     */
    private void init()
    {
        this.setDocument(new NumberValidation());
//        this.setToolTipText("insert PhoneNumbers only!");
    }

    //~ Inner Classes ==========================================================
    /**
     * a Document for the PhoneValidation that only allows PhoneNumbers to be
     * inserted.
     */
    public class NumberValidation extends PlainDocument
    {
        //~ Static fields/initializers =========================================

        private static final long serialVersionUID = 1L;


        //~ Constructors =======================================================
        /**
         * Constructor for the Validationdocument
         */
        public NumberValidation()
        {
            super();
        }

        //~ Methods ============================================================

        public void insertString(int offset, String str, AttributeSet attr)
            throws BadLocationException
        {	
        	
            // generate matcher for Pattern and String
        	m = p.matcher(this.getText(0, this.getLength()) + str);
            if (m.matches()) {
            	if ((getLength() + str.length()) <= limit ) 
            		super.insertString(offset, str, attr);
            } else {
            }
        }
    }
}
