package lu.tudor.santec.gecamed.core.gui.widgets;

import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

/**
 * Helper class to request focus on a component.
 *
 * When the component is added to a realized Window then component will
 * request focus immediately, since the ancestorAdded event is fired
 * immediately.
 *
 * When the component is added to a non realized Window, then the focus
 * request will be made once the window is realized, since the
 * ancestorAdded event will not be fired until then.
 *
 * Using the default constructor will cause the listener to be removed
 * from the component once the AncestorEvent is generated. A second constructor
 * allows you to specify a boolean value of false to prevent the
 * AncestorListener from being removed when the event is generated. This will
 * allow you to reuse the listener each time the event is generated.
 *
 * @version
 * <br>$Log: RequestFocusListener.java,v $
 * <br>Revision 1.1  2012-06-12 14:10:34  troth
 * <br>Helper class to request focus on a component in a dialog create with the JOptionPane class.
 * <br>
 */
public class RequestFocusListener implements AncestorListener
{
	private boolean removeListener;

	/**
	 * With the default constructor the listener is only used once and then it is removed from the component.
	 */
	public RequestFocusListener()
	{
		this(true);
	}

	/**
	 * Constructor that controls whether this listen can be used once or multiple times.
	 *  
	 * @param removeListener when true this listener is only invoked once otherwise it can be invoked multiple times.
	 */
	public RequestFocusListener(boolean removeListener)
	{
		this.removeListener = removeListener;
	}

	public void ancestorAdded(AncestorEvent e)
	{
		JComponent component = e.getComponent();
		component.requestFocusInWindow();

		if (removeListener)
			component.removeAncestorListener(this);
	}

	public void ancestorMoved(AncestorEvent e) {}

	public void ancestorRemoved(AncestorEvent e) {}
}
