/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;

/**
 * Dialog to enter the ip address of the JBoss server to which is connected.
 * The dialog is called by clicking the server address in the login dialog,
 * or if the current server is unreachable
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: ServerDialog.java,v $
 * <br>Revision 1.9  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.8  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.7  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class ServerDialog extends JDialog implements ActionListener
{
    //~ Instance fields ========================================================

	private static final long serialVersionUID = 1L;
	private JButton cancelButton;
    private JButton saveButton;
    private JLabel label;
    private JTextField server;
    private Properties p;

    //~ Constructors ===========================================================
    /**
     * @param owner
     * @param modal
     * @throws java.awt.HeadlessException
     */
    public ServerDialog(Frame owner, Properties localSettings)
        throws HeadlessException
    {
        super(owner, true);
        try {
            p = localSettings;
            this.getContentPane().setLayout(new BorderLayout());
            this.setTitle(Translatrix.getTranslationString("main.serverAddress"));
            this.label = new JLabel(
                    Translatrix.getTranslationString("main.pleaseSpecifyServerAddress")); //$NON-NLS-1$
            this.label.setIcon(GECAMedModule.getIcon(GECAMedIconNames.SERVER));
            this.label.setBorder(Borders.DLU4_BORDER);
            this.getContentPane().add(this.label, BorderLayout.NORTH);
            this.server = new JTextField(p.getProperty("java.naming.provider.url")); 
            NamedComponent nc = new NamedComponent(Translatrix.getTranslationString("main.serverAddress"),this.server);
            nc.setBorder(Borders.DLU4_BORDER);
            this.getContentPane().add(nc, BorderLayout.CENTER);
            //      ButtonPanel
            ButtonBarBuilder bbuilder = new ButtonBarBuilder();
            bbuilder.setDefaultDialogBorder();

            // add Buttons
            this.cancelButton = new JButton(Translatrix.getTranslationString("main.cancel")); //$NON-NLS-1$
            this.cancelButton.addActionListener(this);
            this.saveButton = new JButton(Translatrix.getTranslationString("main.save")); //$NON-NLS-1$
            this.saveButton.addActionListener(this);
            bbuilder.addRelatedGap();
            bbuilder.addGlue();
            bbuilder.addGriddedButtons(new JButton[] {
                    this.cancelButton, this.saveButton
                });
            server.addActionListener(this);
            this.getContentPane().add(bbuilder.getPanel(), BorderLayout.SOUTH);
            this.pack();
            this.showCentered();
            
        } catch (Exception e) {
        }
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e)
    {
        if (e.getSource().equals(this.cancelButton)) {
            this.dispose();
        } else if (e.getSource().equals(this.saveButton)
        		|| e.getSource().equals(this.server)) {
            p.setProperty("java.naming.provider.url", this.server.getText()); 
            System.setProperty("java.naming.provider.url", this.server.getText()); 
            this.dispose();
        }  
    }

    /**
     * shows the Dialog centered on the Screen.
     */
    private void showCentered()
    {
    	Dimension f = this.getSize();
		Point d = GraphicsEnvironment.getLocalGraphicsEnvironment()
				.getCenterPoint();
		this.setLocation(d.x - (f.width / 2), d.y - (f.height / 2));
    	this.setVisible(true);
    }
}
