/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TabMenu extends JPopupMenu implements MouseListener
{
	private static final long serialVersionUID = 1L;
	
	private JTabbedPane	m_TabbedPane;
	private int			m_TabIndex;
	
//***************************************************************************
//* Class Constants				                                            *
//***************************************************************************

	public static final int c_AllTabs	= -1;
	
	private static final int c_YOffset = 17;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor					                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public TabMenu (JTabbedPane p_TabbedPane, int p_TabIndex)
	{
	super();
	
	m_TabbedPane = p_TabbedPane;
	m_TabIndex	 = p_TabIndex;
	
	m_TabbedPane.addMouseListener(this);
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

	
//---------------------------------------------------------------------------
//***************************************************************************
//* Body		                                       						*
//***************************************************************************
//---------------------------------------------------------------------------
	
public void mouseClicked(MouseEvent p_MouseEvent) 
	{
	int			l_TabIndex;
	Component	l_Component;
	
	if (SwingUtilities.isRightMouseButton(p_MouseEvent))
		{
		l_TabIndex = m_TabbedPane.indexAtLocation(p_MouseEvent.getX(), p_MouseEvent.getY());
		if (l_TabIndex >= 0 && l_TabIndex < m_TabbedPane.getTabCount()
				&& (m_TabIndex == c_AllTabs || l_TabIndex == m_TabIndex))
			{
			l_Component = m_TabbedPane.getComponentAt(l_TabIndex);
			
			this.show(l_Component, p_MouseEvent.getX(), p_MouseEvent.getY() - c_YOffset);
			}
		}
	}

//---------------------------------------------------------------------------

public void mouseEntered (MouseEvent p_MouseEvent) 
	{
	}

//---------------------------------------------------------------------------

public void mouseExited (MouseEvent p_MouseEvent) 
	{
	}

//---------------------------------------------------------------------------

public void mousePressed (MouseEvent p_MouseEvent) 
	{
	}

//---------------------------------------------------------------------------

public void mouseReleased (MouseEvent p_MouseEvent) 
	{
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class	                                       					*
//***************************************************************************
//---------------------------------------------------------------------------

}
