///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
//package lu.tudor.santec.gecamed.core.gui.widgets;
//
//import java.awt.BorderLayout;
//import java.awt.GridLayout;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
//import java.io.File;
//import java.io.FileInputStream;
//import java.util.Collection;
//import java.util.HashMap;
//import java.util.Iterator;
//import java.util.Vector;
//import org.apache.log4j.Level;
//import org.apache.log4j.Logger;
//
//import javax.swing.JButton;
//import javax.swing.JComboBox;
//import javax.swing.JFileChooser;
//import javax.swing.JOptionPane;
//import javax.swing.JPanel;
//import javax.swing.JTextField;
//import javax.swing.border.TitledBorder;
//import javax.swing.filechooser.FileFilter;
//
//import lu.tudor.santec.gecamed.core.ejb.entity.beans.Template;
//import lu.tudor.santec.gecamed.core.ejb.session.beans.TemplateManagerBean;
//import lu.tudor.santec.gecamed.core.ejb.session.interfaces.TemplateManagerInterface;
//import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
//import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
//import lu.tudor.santec.gecamed.core.gui.MainFrame;
//import lu.tudor.santec.gecamed.core.gui.utils.WindowToolbox;
//import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
//import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
//import lu.tudor.santec.gecamed.office.ejb.session.beans.OfficeManagerBean;
//import lu.tudor.santec.gecamed.office.ejb.session.interfaces.OfficeManagerInterface;
//import lu.tudor.santec.gecamed.reporting.gui.JRXMLParser;
//import lu.tudor.santec.i18n.Translatrix;
//import lu.tudor.santec.settings.SettingsPlugin;
//
//import com.jgoodies.forms.layout.CellConstraints;
//import com.jgoodies.forms.layout.FormLayout;
//
///**
//*
//* @author nmac / jhermen
//*/
//
//public class TemplateSettingsPlugin extends SettingsPlugin implements ActionListener {
//	private static final long serialVersionUID = 1L;
//	
//	/**
//	 * static logger for this class
//	 */
//	private static Logger logger = Logger
//			.getLogger(TemplateSettingsPlugin.class.getName());
//	
//	public static final String NAME = "templates";
//	private JPanel wrPanel;
//	private JComboBox phyChooser;
//
//	private OfficeManagerInterface officeManager;
//
//	private JPanel templatesPanel;
//
//	private TemplateManagerInterface listManager;
//	
//	private HashMap<String, TemplatePanel> panels = new HashMap<String, TemplatePanel>();
//
//	private static JFileChooser jfc = new JFileChooser();
//
//	public TemplateSettingsPlugin(String p_Name) {
//		super(p_Name);
//		this.setStationaryValues();
//		buildPanel();
//	}
//	
//	public TemplateSettingsPlugin() {
//		super(NAME);
//		this.setStationaryValues();
//		buildPanel();
//	}
//
//	private void buildPanel() {
//		
//		setLabel(Translatrix.getTranslationString("template.templates"));
//		
//   	 	// Get the type manager
//		this.officeManager = (OfficeManagerInterface) ManagerFactory.getRemote(OfficeManagerBean.class);
//		this.listManager = (TemplateManagerInterface) ManagerFactory.getRemote(TemplateManagerBean.class);
//		
//		this.wrPanel = createSubPanel(Translatrix
//				.getTranslationString("template.templateSettings"));
//		this.wrPanel.setLayout(new BorderLayout(5,5));
//
//		Vector<Physician> v = new Vector<Physician>(this.officeManager.getAllPhysicians());
//		Physician p = new Physician(Translatrix.getTranslationString("template.office"));
//		p.setId(Template.OFFICE);
//		v.add(0, p);
//		this.phyChooser = new JComboBox(v);
//		this.phyChooser.addActionListener(this);
//		wrPanel.add(new NamedComponent(Translatrix.getTranslationString("template.physician"), this.phyChooser), BorderLayout.NORTH);
//		
//		this.templatesPanel = new JPanel(new GridLayout(0,1,5,5));
//		
//		String[] templateTypes = new String[0];
//		try {
//			templateTypes = listManager.getTemplateTypes();			
//		} catch (Exception e) {
//		}
//		
//		
//		for (int i = 0; i < templateTypes.length; i++) {
//			
//			TemplatePanel tp = new TemplatePanel(templateTypes[i], "default");
//			panels.put(templateTypes[i], tp);
//			templatesPanel.add(tp);			
//		}
//		
//		phyChooser.setSelectedIndex(0);
//
//		
//		wrPanel.add(templatesPanel, BorderLayout.CENTER);
//		addSubPanel(wrPanel);
//
//		setIcon(GECAMedModule.getIcon(GECAMedIconNames.TEMPLATE));
//	}
//
//	public void revertToDefaults() {
//		reflectSettings();
//		super.revertToDefaults();
//	}
//
//	public void updateSettings() {
//		super.updateSettings();
//	}
//
//	public void reflectSettings() {
//		super.reflectSettings();
//	}
//
//	public void relocalize() {
//		super.relocalize();
//		setLabel(Translatrix.getTranslationString("template.templates"));
//		setSubPanelTitle(wrPanel, Translatrix
//				.getTranslationString("template.templateSettings"));
//	}
//	
//	public void setStationaryValues() {
//	}
//	
//	public void actionPerformed(ActionEvent e) {
//		if (e.getSource().equals(this.phyChooser)) {			
//			try {
//
//				for (Iterator iter = panels.values().iterator(); iter.hasNext();) {
//					TemplatePanel p = (TemplatePanel) iter.next();
//					p.setName("default");
//				}
//				
//				Integer physicianID = ((Physician)phyChooser.getSelectedItem()).getId();
//				Collection<Template> tmp = listManager.getTemplatesByPhysicianID(physicianID);
//				for (Iterator iter = tmp.iterator(); iter.hasNext();) {
//					Template element = (Template) iter.next();
//					TemplatePanel p = panels.get(element.getType());
//					if (p != null) {
//						p.setName(element.getName());
//					} 
//				}
//			} catch (Exception e1) {
//				logger.log(Level.WARN, "fetching templates failed", e);
//			}
//		}
//	}
//	
//	
//	
//	class TemplatePanel extends JPanel implements ActionListener {
//		
//		private static final long serialVersionUID = 1L;
//		private JTextField nameField;
//		private JButton chooser;
//		private String templateName;
//		protected byte[] templateBytes;
//		private String type;
//		private JButton delete;
//
//
//		public TemplatePanel(String type, String name) {
//			this.setBorder(new TitledBorder(type));
//			this.type = type;
//			this.setLayout(new FormLayout("pref:grow, pref, pref", "pref"));
//			CellConstraints cc = new CellConstraints();
//			nameField = new JTextField(name);
//			nameField.setEditable(false);
//			this.add(nameField, cc.xy(1,1));
//			this.chooser = new JButton("...");
//			this.chooser.addActionListener(this);
//			this.add(chooser, cc.xy(2,1));
//			
//			this.delete = new JButton("reset");
//			this.delete.addActionListener(this);
//			this.add(delete, cc.xy(3,1));
//		}
//
//		public void actionPerformed(ActionEvent e) {
//			if (e.getSource().equals(chooser)) {
//				addTemplate(this.type);
//			} else if (e.getSource().equals(delete)) {
//				if (JOptionPane.showConfirmDialog(MainFrame.getInstance(), Translatrix
//						.getTranslationString("really reset to default Template?"), Translatrix
//						.getTranslationString("reset Template"),
//						JOptionPane.YES_NO_OPTION,
//						JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
//					try {
//						Integer physicianID = ((Physician)phyChooser.getSelectedItem()).getId();
//						listManager.deleteTemplate(physicianID, type);		
//						nameField.setText("default");
//					} catch (Exception ee) {
//						logger.log(Level.WARN, "resetting templates failed", ee);
//					}
//				}
//			}
//		}
//		
//		public void setName(String name) {
//			this.nameField.setText(name);
//		}
//		
//		
//		protected void addTemplate(final String templateType) {
//			jfc.setFileFilter(new FileFilter() {
//				public boolean accept(File f) {
//					try {
//						if (f.isDirectory() || f.getName().toLowerCase().endsWith(".jrxml"))
//							return true;
//					} catch (Exception e) {
//					}
//					return false;
//				}
//				public String getDescription() {
//					return "JRXML (JasperReport XML files)";
//				}
//				
//			});
//			
//			if (jfc.showOpenDialog(MainFrame.getInstance()) == JFileChooser.APPROVE_OPTION) {
//				
//				new Thread() {
//
//					public void run() {
//						MainFrame.getInstance().setWaitCursor(true);
//						try {
//							File reportFile = jfc.getSelectedFile();
//							templateBytes = new byte[(int) reportFile.length()];
//							new FileInputStream(reportFile).read(templateBytes);
//							
//							parseJRXML();
//							
//							Integer physicianID = ((Physician)phyChooser.getSelectedItem()).getId();
//							
//							// check for matching reportName
//							Template template = listManager.findTemplateByTypeAndPhysicianID(templateType, physicianID);
//							if (template  == null) {
//								template = new Template();	
//								logger.info("saving new template " + templateName + " to DB");
//							} else {
//								logger.info("updating template " + templateName + " to DB");
//							}
//							
////							ByteArrayOutputStream bous = new ByteArrayOutputStream();
////							JasperCompileManager.compileReportToStream(
////									new ByteArrayInputStream(templateBytes), bous);
//							
//							template.setType(templateType);
//							template.setPhysicianID(physicianID);
//							template.setName(templateName);
//							template.setJrxml(templateBytes);
//							template.setJasper(null);
//							
//							template = listManager.saveTemplate(template);
//							
//							nameField.setText(templateName);
//						} catch (Exception e) {
//							MainFrame.getInstance().setWaitCursor(false);
//							ErrorDialog.showErrorDialog(MainFrame.getInstance(), e);
//						}
//						MainFrame.getInstance().setWaitCursor(false);
//					}
//				}.start();
//			}
//		}
//		
//		public void parseJRXML() {
//			JRXMLParser parser = new JRXMLParser();
//			try {
//				parser.parseFile(templateBytes);
//				templateName = parser.getReportName();
//			} catch (Exception e) {
//				ErrorDialog.showErrorDialog(MainFrame.getInstance(), e);
//			}
//		}
//	}
//
//}
