/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;


/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TimeCellEditor extends AbstractCellEditor implements TableCellEditor,
																  ActionListener
    {
    private TimeEditorField m_TimeField; 
	
	private static final long serialVersionUID = 1L;
     
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public TimeCellEditor() 
    {
	super ();
	
	m_TimeField = new TimeEditorField (new TimeFormatter());
	m_TimeField.setValue (TimeFormatter.c_EmptyField);
	m_TimeField.addActionListener (this);
    }
    
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{	
	return m_TimeField.getValue();
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent (JTable p_Table, Object p_Value,
        									  boolean p_IsSelected, int p_Row, int p_Column)
	{	
	TimeFormatter	l_Formatter;
	
	if (p_Value instanceof Date)
		{
		l_Formatter = (TimeFormatter) m_TimeField.getFormatter();
		m_TimeField.setValue(l_Formatter.valueToString(p_Value));		
		}
	
	return m_TimeField;
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	this.stopCellEditing();
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

