/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;


import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.text.MaskFormatter;


/**
 * The TimeFormatter swing component eases the input of Time data.
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TimeFormatter extends MaskFormatter                                                              
    {
    private static final long serialVersionUID = 1L;
    
    public final static Date c_ZeroTime = new GregorianCalendar (0,0,0,0,0,0).getTime();
    
    protected final static Pattern 
    
    c_TimePattern = Pattern.compile ("^([01]?[0-9]|2[0-3]):(\\d{2})$",Pattern.CASE_INSENSITIVE);
     
    public static final String c_EmptyField = "00:00";

    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public TimeFormatter() 
    {
	try {
		this.setMask("##:##");
		} 
    catch (ParseException p_Exception) 
        {
    		//Can be safely ignored here.
        }
    
    this.setAllowsInvalid(false);
    this.setValidCharacters("0123456789");
    this.setPlaceholderCharacter('-');
    this.setOverwriteMode(true);
    this.setValueContainsLiteralCharacters(true);
    this.setCommitsOnValidEdit(false);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public Object stringToValue (String p_Time)
	{
	GregorianCalendar	l_Calendar;
	Date	   			l_Time;
	Matcher				l_Matcher;
	int					l_Hours   = 0;
	int					l_Minutes = 0;
	
	this.setEditValid(false);
	
	l_Matcher = c_TimePattern.matcher (p_Time);
     if (l_Matcher.matches())
        {
    	l_Hours   = (new Integer (l_Matcher.group(1))).intValue();
    	l_Minutes = (new Integer (l_Matcher.group(2))).intValue();  	    	 
        this.setEditValid(true);
        }
    
    l_Calendar = new GregorianCalendar (0,0,0,l_Hours,l_Minutes,0);
    l_Time = l_Calendar.getTime();
	
	return l_Time;
	}

//---------------------------------------------------------------------------

public String valueToString (Object p_Value)
	{
	GregorianCalendar	l_Calendar;
	String				l_Value;
	int					l_Hours;
	int					l_Minutes;
	
	this.setEditValid(false);
	
	if (p_Value instanceof Date)
		{
		l_Calendar = new GregorianCalendar ();
		l_Calendar.setTime((Date)p_Value);
		l_Hours   = l_Calendar.get(Calendar.HOUR_OF_DAY);
		l_Minutes = l_Calendar.get(Calendar.MINUTE);
			
		l_Value  = (l_Hours < 10)? "0"   + Integer.valueOf(l_Hours).toString():Integer.valueOf(l_Hours).toString();
		l_Value += ":";
		l_Value += (l_Minutes < 10)? "0" + Integer.valueOf(l_Minutes).toString():Integer.valueOf(l_Minutes).toString();
		this.setEditValid(true);
		}
	else l_Value = c_EmptyField;
	
	return l_Value;
	}

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}


