package lu.tudor.santec.gecamed.core.gui.widgets.autocompletion;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.Autocompletion;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.org.fife.ui.autocomplete.CompletionProvider;
import lu.tudor.santec.org.fife.ui.autocomplete.MultiWordCompletion;

public class GECAMedAutoCompletion extends MultiWordCompletion
{
	private Autocompletion bean;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	/**
	 * @param provider
	 * @param completion
	 */
	public GECAMedAutoCompletion (CompletionProvider provider,
			Autocompletion completion)
	{
		super(provider, 
				completion.getInputText() != null && !completion.getInputText().trim().equals("") 
						? completion.getInputText() 
						: completion.getReplacementText(), 
				completion.getReplacementText());
		this.bean = completion;
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	/**
	 * @return
	 */
	public Autocompletion getACBean ()
	{
		return bean;
	}
	
	public void setACBean (Autocompletion ac)
	{
		this.bean = ac;
	}
	
	
	/**
	 * @return
	 */
	public boolean isPrivate ()
	{
		return bean.getUserId() != null;
	}
	
	/**
	 * @param value
	 */
	public void setPrivate (boolean value)
	{
		if (value == isPrivate())
			return;
		else if (value)
			bean.setUserId(GECAMedModule.getCurrentUser().getId());
		else
			bean.setUserId(null);
	}
	
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.MultiWordCompletion#setInputText(java.lang.String)
	 */
	@Override
	public void setInputText(String text)
	{
		super.setInputText(text);
		if (bean != null) bean.setInputText(isInputTextSet() ? super.getInputText() : null);
	}
	
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.MultiWordCompletion#setReplacementText(java.lang.String)
	 */
	@Override
	public void setReplacementText(String text)
	{
		super.setReplacementText(text);
		if (bean != null) bean.setReplacementText(super.getReplacementText());
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		boolean equal = super.equals(obj);
		
		if (equal && obj instanceof GECAMedAutoCompletion)
			equal = this.isPrivate() == ((GECAMedAutoCompletion)obj).isPrivate();
		
		return equal;
	}
}
