package lu.tudor.santec.gecamed.core.gui.widgets.autocompletion;

import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;

import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.org.fife.ui.autocomplete.dialog.SaveCompletionDialog;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

public class GECAMedSaveCompletionDialog extends SaveCompletionDialog
{
	private static final long serialVersionUID = 1L;
	private static final RowSpec rowSpec = new RowSpec(Sizes.PREFERRED);
	
	protected JCheckBox markPrivateBox;
	
	
	public GECAMedSaveCompletionDialog(JDialog owner, GECAMedAutoCompletionTextComponent textComponent)
	{
		super(owner, textComponent);
		init();
	}
	
	public GECAMedSaveCompletionDialog(JFrame owner, GECAMedAutoCompletionTextComponent textComponent)
	{
		super(owner, textComponent);
		init();
	}
	
	private void init ()
	{
		markPrivateBox = new JCheckBox(Translatrix.getTranslationString("MultiWordAutoCompletion.markPrivate"));
		markPrivateBox.setOpaque(false);
		
		FormLayout layout = (FormLayout)mainPanel.getLayout();
		layout.appendRow(rowSpec);
		
		mainPanel.add(markPrivateBox, new CellConstraints(1, layout.getRowCount(), layout.getColumnCount(), 1));
		
		this.pack();
	}
	
	
	@Override
	protected void saveCompletion()
	{
		String replacementText 			= replacementTextArea.getText();
		String inputText 				= inputTextField.getText().trim();
		boolean isPrivate				= markPrivateBox.isSelected();
		
		((GECAMedAutoCompletionTextComponent)view).addCompletion(inputText, replacementText, isPrivate);
	}
}
