package lu.tudor.santec.gecamed.core.gui.widgets.incidentfileoverview;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.utils.IncidentFileInfo;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.i18n.Translatrix;

public class IncidentFileOverviewModel extends AbstractTableModel
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	private static final int	COLUMN_COUNT		= 5;
	
	public static final int		DATE_COLUMN			= 0;
	public static final int		PHYSICAN_COLUMN		= 1;
	public static final int		PATIENT_COLUMN		= 2;
	public static final int		FILE_COLLUMN		= 3;
	public static final int		USER_COLUMN			= 4;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static Vector<String>		columnIdentifiers	= new Vector<String>(COLUMN_COUNT);
	
	private static IncidentManager		incidentManager;
	
	
	private Vector<IncidentFileInfo>	data;
	
	private Map<Integer, JComponent>	userColumnComponents	= new HashMap<Integer, JComponent>();
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public IncidentFileOverviewModel () 
	{
		if (columnIdentifiers.isEmpty())
		{
			columnIdentifiers.add(Translatrix.getTranslationString("core.incidentFileOverview.enryDate"));
			columnIdentifiers.add(Translatrix.getTranslationString("core.incidentFileOverview.physician"));
			columnIdentifiers.add(Translatrix.getTranslationString("core.incidentFileOverview.patient"));
			columnIdentifiers.add(Translatrix.getTranslationString("core.incidentFileOverview.fileName"));
			columnIdentifiers.add(Translatrix.getTranslationString("core.incidentFileOverview.approvedBy"));
		}
		
		this.data	= new Vector<IncidentFileInfo>();
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public void setData (Vector<IncidentFileInfo> newData)
	{
		this.data	= newData;
		super.fireTableDataChanged();
	}
	
	
	public void reload (boolean loadApprovedFiles, boolean loadFilesForAllPhysicians)
	{
		IncidentManager				manager;
		Physician					physician;
		Vector<IncidentFileInfo>	newData;
		
		manager		= getManager();
		physician	= loadFilesForAllPhysicians 
				? null 
				: GECAMedModule.getCurrentPhysician();
		newData		= new Vector<IncidentFileInfo>(
				manager.getIncidentFiles(loadApprovedFiles, physician));
		
		setData(newData);
	}
	
	
	public void approve (IncidentFileInfo fileInfo)
	{
		int				affectedRow	= data.indexOf(fileInfo);
		GecamedUser		currentUser	= GECAMedModule.getCurrentUser();
		IncidentManager manager		= getManager();
		IncidentEntry	entry		= fileInfo.getEntry();
		
		entry	= manager.setEntryCode(entry, currentUser.getId().toString());
		fileInfo.setUser(currentUser);
		fireTableCellUpdated(affectedRow, USER_COLUMN);
	}
	
	
	public void disapprove (IncidentFileInfo fileInfo)
	{
		int				affectedRow	= data.indexOf(fileInfo);
		IncidentManager manager		= getManager();
		IncidentEntry	entry		= fileInfo.getEntry();
		
		entry	= manager.setEntryCode(entry, null);
		fileInfo.setUser(null);
		fireTableCellUpdated(affectedRow, USER_COLUMN);
	}
	
	
	public void putUserColumnComponent (Integer row, JComponent component)
	{
		userColumnComponents.put(row, component);
	}
	
	
	public JComponent getUserColumnComponent (Integer row)
	{
		return userColumnComponents.get(row);
	}
	
	
	
	/* ======================================== */
	// 		DERIVED METHODS
	/* ======================================== */
	
	@Override
	public String getColumnName (int column)
	{
		if (column < columnIdentifiers.size())
			 return columnIdentifiers.get(column);
		else return "";
	}
	
	
	public int getRowCount ()
	{
		return data.size();
	}
	
	
	public int getColumnCount ()
	{
		return columnIdentifiers.size();
	}
	
	
	public IncidentFileInfo getValueAt (int rowIndex, int columnIndex)
	{
		return data.get(rowIndex);
	}
	
	
	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex)
	{
		return false;
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	public static IncidentManager getManager ()
	{
		if (incidentManager == null)
			incidentManager	= (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
		
		return incidentManager;
	}
}
