/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.progress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

/**
 * The ProgressEventDispatcher class basically encapsulates functionality
 * required to manage ProgressEvent Listeners. It offers methods to add and
 * remove ProgressListeners as well as a method to call every registered
 * listener's progressChanged method.
 * @autor nico.mack@tudor.lu
 */

public class ProgressEventDispatcher 
{
	private Collection <ProgressListener> m_ProgressListeners;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new instance of ProgressEventDispatcher class.
 */
//---------------------------------------------------------------------------

public ProgressEventDispatcher ()
	{
	m_ProgressListeners = new ArrayList <ProgressListener> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Adds the specified ProgressListener to the list of listeners to be
 * notified.
 * @param p_Listener specifies the ProgressListener to be added
 */
//---------------------------------------------------------------------------


public void addProgressListener (ProgressListener p_Listener)
	{
	if ((m_ProgressListeners == null) || (p_Listener == null)) return;
	
	m_ProgressListeners.add(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * Removes the specified ProgressListener from the list of listeners to be
 * notified.
 * @param p_Listener specifies the ProgressListener to be removed
 */
//---------------------------------------------------------------------------

public void removeProgressListener (ProgressListener p_Listener)
	{
	if ((m_ProgressListeners == null) || (p_Listener == null)) return;

	if (m_ProgressListeners.contains(p_Listener)) 
		m_ProgressListeners.remove(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * the notifyProgressListeners will notify all the registered Listener's
 * about the progress change represented by the specified progress event.
 * Notification is done by calling every listener's <code>progressChanged</code>
 * method.
 * @param p_Event specifies the progress change event to be passed to every
 * listener's <code>progressChanged</code> method.
 */
//---------------------------------------------------------------------------

public void notifyProgressListeners (ProgressEvent p_Event)
	{
	Iterator <ProgressListener>	l_ListenerIterator;
	ProgressListener			l_Listener;
	
	if (m_ProgressListeners == null) return;
	
	l_ListenerIterator = m_ProgressListeners.iterator();
	while (l_ListenerIterator.hasNext())
		{
		l_Listener = l_ListenerIterator.next();
		l_Listener.progressChanged(p_Event);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------


}
