/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * The SearchColumnAttributes class encapsulates common data characterizing
 * a search column in the scope of the search table header package.
 * @author nico.mack@tudror.lu
 */

public class SearchColumnAttributes 
	{
	private boolean m_IsEnabled;
	private boolean m_IsMutualExclusive;
	private boolean m_IsSearching;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public SearchColumnAttributes ()
	{
	m_IsEnabled 		= false;
	m_IsMutualExclusive = false;
	m_IsSearching 		= false;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                      						*
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * sets the enabled property for this column.
 * @param p_IsEnabled specifies the new value for the property.
 */
//---------------------------------------------------------------------------

public void setEnabled (boolean p_IsEnabled)
	{
	m_IsEnabled = p_IsEnabled;
	}

//---------------------------------------------------------------------------
/**
 * checks whether or not this column is enabled.
 * @return <code>true</code> if column is enabled, <code>false</code>
 * otherwise.
 */
//---------------------------------------------------------------------------

public boolean isEnabled ()
	{
	return m_IsEnabled;
	}

//---------------------------------------------------------------------------
/**
 * sets the mutual exclusivness property for this column. If a column is mutual
 * exclusive, this means that if this column becomes enabled, all other columns
 * will have to be disabled.
 * @param  p_IsMutualExclusive specifies the new value for the mutual exclusivness
 * property.
 */
//---------------------------------------------------------------------------

public void setMutualExclusive (boolean p_IsMutualExclusive)
	{
	m_IsMutualExclusive = p_IsMutualExclusive;
	}

//---------------------------------------------------------------------------
/**
 * checks whether or not this column is mutual exclusive.
 * @return <code>true</code> if column is mutual exclusive, <code>false</code>
 * otherwise.
 */
//---------------------------------------------------------------------------

public boolean isMutualExclusive ()
	{
	return m_IsMutualExclusive;
	}

//---------------------------------------------------------------------------
/**
 * Sets the searching property for this column.
 * @param p_IsSearching specifies the new value for the searching property.
 */
//---------------------------------------------------------------------------

public void setSearching (boolean p_IsSearching)
	{
	m_IsSearching = p_IsSearching;
	}

//---------------------------------------------------------------------------
/**
 * checks whether or not this column is currently searching.
 * @return <code>true</code> if column is mutual searching, <code>false</code>
 * otherwise.
 */
//---------------------------------------------------------------------------

public boolean isSearching ()
	{
	return m_IsSearching;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
}


