/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
  * The SearchResetAction extends AbstractAction and calls the resetSearch
  * method on specified table if performed.
  * @author nico.mack@tudor.lu 
  */

public class SearchResetAction extends AbstractAction
	{
	private static final long serialVersionUID = 1L;
	
	private SearchableTable	m_Table;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor					                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new instance of SearchResetAction. The action will call the
 * resetSearch method of specified table when action is performed.
 * @param p_Table specifies the table implementing the SearchableTable
 * interface and whose resetSearch method should be called upon action 
 * perform.
 * @param p_Name specifies a name for this action.
 */
//---------------------------------------------------------------------------

public SearchResetAction (SearchableTable p_Table, String p_Name)
	{
	super(p_Name);
	
	m_Table = p_Table;
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body					                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * The actionPerformed method is part of the ActionListener interface.
 * When the action event occurs, the actionPerformed method is invoked. In
 * our case, we're going to call the resetSearch method on table specified
 * at instantiation time.
 */
//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event)
	{
	if (m_Table != null) m_Table.resetSearch ();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}	
