/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.templates;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

import javax.swing.JComboBox;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.Template;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.core.utils.JasperTemplateBean;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.office.ejb.session.beans.OfficeManagerBean;
import lu.tudor.santec.gecamed.office.ejb.session.interfaces.OfficeManagerInterface;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

/**
*
* @author nmac / jhermen
*/

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TemplateSettings extends SettingsPlugin implements ActionListener,
																PropertyChangeListener 
	{
	private static final long serialVersionUID = 1L;
	
	/**
	 * static logger for this class
	 */
//	private static Logger logger = Logger.getLogger(TemplateSettings.class.getName());
	
	public static final String NAME = "templates";
	private JPanel wrPanel;
	private JComboBox phyChooser;

	private OfficeManagerInterface officeManager;

	private JPanel templatesPanel;

	private String[] 				m_TemplateTypes;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public TemplateSettings(String p_Name) 
	{
	super(p_Name);
	this.setStationaryValues();
	buildPanel();
	}
	
//---------------------------------------------------------------------------

public TemplateSettings() 
	{
	super(NAME);
	this.setStationaryValues();
	buildPanel();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************
//---------------------------------------------------------------------------

private void buildPanel() 
	{	
	FormLayout 			l_Layout;
	CellConstraints		l_Constraints;
	Vector<Physician>	l_Physicians;
	Physician			l_Physician;
	
	l_Layout = new FormLayout ("fill:pref:grow","3dlu,pref,3dlu,pref,3dlu");
	l_Constraints = new CellConstraints ();
		
	setLabel(Translatrix.getTranslationString("template.templates"));
		
   	 	// Get the type manager
	this.officeManager = (OfficeManagerInterface) ManagerFactory.getRemote(OfficeManagerBean.class);
	this.wrPanel = createSubPanel(Translatrix.getTranslationString("template.templateSettings"));
	this.wrPanel.setLayout(l_Layout);

	l_Physicians = new Vector<Physician> (GECAMedLists.getListReference(Physician.class));
		
	l_Physician = new Physician(Translatrix.getTranslationString("template.office"));
	l_Physician.setId (Template.OFFICE);
	l_Physicians.add(0, l_Physician);
		
	this.phyChooser = new JComboBox(l_Physicians);
	this.phyChooser.addActionListener(this);
	wrPanel.add(new NamedComponent(Translatrix.getTranslationString("template.physician"), this.phyChooser), l_Constraints.xy(1, 2));

	m_TemplateTypes = JasperTemplateBean.TYPES;
//	try {
//		m_TemplateTypes = listManager.getTemplateTypes();
//		} 
//	catch (Exception e) 
//		{
//		}
		
	phyChooser.setSelectedIndex(0);
	l_Physician = ((Physician)phyChooser.getSelectedItem());
	
	templatesPanel = this.buildTemplatesPanel(m_TemplateTypes, l_Physician);
	wrPanel.add(templatesPanel, l_Constraints.xy(1, 4));
	addSubPanel(wrPanel);
		
	setIcon(GECAMedModule.getIcon(GECAMedIconNames.TEMPLATE));
	}

//---------------------------------------------------------------------------

private JPanel buildTemplatesPanel (String[] p_TemplateTypes, Physician p_Physician) 
	{
	FormLayout 			l_Layout;
	CellConstraints		l_Constraints;
	JPanel				l_TemplatePanel;
	int					l_Index;
	TemplateGroupPanel	l_TemplateGroup;
	
	l_TemplatePanel = new JPanel ();
	
	l_Layout = new FormLayout ("left:pref:grow","");
	l_Constraints = new CellConstraints ();

	l_TemplatePanel.setLayout(l_Layout);
	
	for (l_Index = 0; l_Index < p_TemplateTypes.length; l_Index++) 
		{	
		l_Layout.appendRow (new RowSpec (Sizes.PREFERRED));
			
		l_TemplateGroup = new TemplateGroupPanel (p_TemplateTypes[l_Index], p_Physician);
		l_TemplateGroup.addPropertyChangeListener(this);
		l_TemplatePanel.add(l_TemplateGroup,l_Constraints.xy(1, (l_Index+1)));			
		}
	
	return l_TemplatePanel;
	}

//---------------------------------------------------------------------------

public void revertToDefaults() 
	{
	reflectSettings();
	super.revertToDefaults();
	}

//---------------------------------------------------------------------------

public void updateSettings() 
	{
	super.updateSettings();
	}

//---------------------------------------------------------------------------

public void reflectSettings() 
	{
	super.reflectSettings();
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	super.relocalize();
	setLabel(Translatrix.getTranslationString("template.templates"));
	setSubPanelTitle(wrPanel, Translatrix.getTranslationString("template.templateSettings"));
	}
	
//---------------------------------------------------------------------------

public void setStationaryValues() 
	{
	}
	
//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event) 
	{
	Physician 		l_Physician;
	CellConstraints	l_Constraints;
	
	if (p_Event.getSource().equals(this.phyChooser)) 
		{			
		l_Physician = (Physician)phyChooser.getSelectedItem();

		if (templatesPanel instanceof JPanel)
			{
			wrPanel.remove(templatesPanel);
			templatesPanel = this.buildTemplatesPanel(m_TemplateTypes, l_Physician);
	
			l_Constraints = new CellConstraints ();
			wrPanel.add(templatesPanel, l_Constraints.xy(1, 4));
			
			wrPanel.validate();
			}
		}
	}

//---------------------------------------------------------------------------

public void propertyChange(PropertyChangeEvent p_Event) 
	{
	if (p_Event.getSource() instanceof TemplateGroupPanel)
		{
		templatesPanel.validate();
		}	
	}
	
//---------------------------------------------------------------------------	
//***************************************************************************
//* End of Class															*
//***************************************************************************
//---------------------------------------------------------------------------	

}
