package lu.tudor.santec.gecamed.core.gui.widgets.xslt;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.XSLTemplate;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.FormTemplate;
import lu.tudor.santec.gecamed.formeditor.gui.controller.converter.FormDataConverter;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;




public class ChooseXslDialog extends GECAMedBaseDialogImpl implements ActionListener
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	private static final RowSpec EMPTY_ROW 		= new RowSpec(Sizes.pixel(5));
	private static final RowSpec DEFAULT_ROW 	= new RowSpec(RowSpec.FILL, Sizes.PREFERRED, 0.0);
	private static final CellConstraints CC 	= new CellConstraints();
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static ChooseXslDialog instance;
	
	private ButtonGroup boxesGroup;
	
	private FormLayout 	boxesLayout;
	
	private JPanel 		boxesPanel;
	
	private HashMap<ButtonModel, XSLTemplate> modelTemplateMatcher;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public ChooseXslDialog ()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("Choose an XSL template"), 
				OK_CANCEL_BUTTON_MODE);
		
		mainPanel.setLayout(new BorderLayout());
		boxesLayout = new FormLayout("5px, f:p:g, 5px");
		boxesPanel 	= new JPanel(boxesLayout);
		boxesPanel.setOpaque(false);
		mainPanel.add(boxesPanel, BorderLayout.CENTER);
		
		okButton.setText(Translatrix.getTranslationString("core.print"));
		okButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.PRINT));
		
		modelTemplateMatcher = new HashMap<ButtonModel, XSLTemplate>();
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public XSLTemplate show (List<XSLTemplate> templates)
	{
		XSLTemplate choosenTemplate;
		ButtonModel selectedModel;
		
		// reset and prepare
		boxesGroup = new ButtonGroup();
		modelTemplateMatcher.clear();
		boxesPanel.removeAll();
		while (boxesLayout.getRowCount() > 0)
			boxesLayout.removeRow(boxesLayout.getRowCount());
		
		// add the check boxes
		for (XSLTemplate template : templates)
		{
			addBoxRow(template);
		}
		okButton.setEnabled(boxesGroup.getSelection() != null);
		
		// prepare and show the dialog
		this.pack();
		this.setLocationRelativeTo(getOwner());
		this.setVisible(true);
		
		// return the selected template
		if (this.getButtonOption() == OK_OPTION)
		{
			selectedModel 	= boxesGroup.getSelection();
			choosenTemplate = modelTemplateMatcher.get(selectedModel);
		}
		else choosenTemplate = null;
		
		return choosenTemplate;
	}
	
	
	
	/* ======================================== */
	// 		OVERRIDDEN METHODS
	/* ======================================== */
	
//	@Override
//	public void cancelActionCalled()
//	{
//		boxesGroup.clearSelection();
//		super.cancelActionCalled();
//	}
	
	
	
	/* ======================================== */
	// 		LISTENER METHODS
	/* ======================================== */

	public void actionPerformed(ActionEvent e)
	{
		okButton.setEnabled(boxesGroup.getSelection() != null);
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private void addBoxRow (XSLTemplate template)
	{
		JRadioButton box = new JRadioButton(template.getName());
		box.setOpaque(false);
		box.addActionListener(this);
		modelTemplateMatcher.put(box.getModel(), template);
		boxesGroup.add(box);
		
		boxesLayout.appendRow(DEFAULT_ROW);
		boxesPanel.add(box, CC.xy(2, boxesLayout.getRowCount()));
		boxesLayout.appendRow(EMPTY_ROW);
	}
	
	
	public static XSLTemplate getXslTemplate (String type, FormTemplate formTemplate)
	{
//		FormTemplate 		formTemplate = this.model.getTemplate();
		List<XSLTemplate> 	templates;
		XSLTemplate 		template;
		
		if (type == FormDataConverter.TYPE_PRINT)
			templates = formTemplate.getPrintableTemplates(
					MainFrame.getCurrentPhysician());
		else /* if (type == TYPE_EDIT) */
			templates = formTemplate.getEditableTemplates(
					MainFrame.getCurrentPhysician());
		
		if (templates == null || templates.isEmpty())
			return null;
		else if (templates.size() == 1)
			template = templates.get(0);
		else
		{
			template = chooseXslTemplate(templates);
			if (template == null)
				return null;
		}
		
		return template;
	}
	
	
	private static XSLTemplate chooseXslTemplate (List<XSLTemplate> templates)
	{
		if (instance == null)
			instance = new ChooseXslDialog();
		
		return instance.show(templates);
	}
}
