/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.schedulable;

import java.util.Date;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;

import org.jboss.varia.scheduler.Schedulable;

/**
 * This class triggers a minutely heatbeat message that is send to the  
 * "topic/gecamed/heartbeat" JMS Topic. Message driven beans may register 
 * to this topic to get the minutely heatbeat.
 * 
 * This class is triggered by a JBoss MBean configured in the 
 * META-INF/jboss-service.xml
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: GECAMedHeartbeatPoster.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-04-01 06:26:59  hermen
 * <br>added comments
 * <br>
 *
 */
public class GECAMedHeartbeatPoster implements Schedulable
{

	/**
	 * Text of the JMS message
	 */
	public static final String DoMinutely = "DoMinutely";
	
	/**
	 * JMS topic
	 */
	public static final String HeartbeatTopic = "topic/gecamed/heartbeat";
	
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

/**
 * 
 * @param p_Message
 */
public GECAMedHeartbeatPoster (String p_Message)
	{
	}
	
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
/* (non-Javadoc)
 * @see org.jboss.varia.scheduler.Schedulable#perform(java.util.Date, long)
 */
public void perform(Date arg0, long arg1) 
	{
	Topic 					l_Topic		 = null;
	TopicConnectionFactory 	l_Factory	 = null;
	TopicConnection			l_Connection = null;
	TopicSession			l_Session	 = null;
	TopicPublisher				l_Publisher	 = null;
		
	try {
		InitialContext l_Context = new InitialContext();
		l_Topic = (Topic) l_Context.lookup(HeartbeatTopic);
		l_Factory = (TopicConnectionFactory) l_Context.lookup("ConnectionFactory");
		l_Connection = l_Factory.createTopicConnection();
		l_Session = l_Connection.createTopicSession(false,TopicSession.AUTO_ACKNOWLEDGE);
		} 
	catch (Exception e) 
		{
		e.printStackTrace ();
		}

	if (l_Session == null) return;
	
	try	{
		TextMessage msg = l_Session.createTextMessage(DoMinutely);
		l_Publisher = l_Session.createPublisher(l_Topic);
		l_Publisher.publish(msg);
		l_Publisher.close();
		l_Session.close();
		l_Connection.close();
		}
	catch (JMSException p_Exception)
		{
		p_Exception.printStackTrace();
		}		
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************

}
