/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: TestGlobalHotkeyRegister.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2007-12-04 14:03:37  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>same with phycianlistener
 * <br>
 * <br>Revision 1.1  2007-11-30 14:25:14  heinemann
 * <br>initial checkin
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.test;



import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.RegistrationDesk;
import lu.tudor.santec.gecamed.core.gui.listener.GlobalHotkeyRegister;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * 
 * Test the GlobalHotkeyRegister class to register hotkey.<br/>
 * Please use RegistrationDesk for registering and any further interaction
 * 
 * @author martin.heinemann@tudor.lu
 * 30.11.2007
 * 11:13:59
 *
 *
 * @version
 * <br>$Log: TestGlobalHotkeyRegister.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2007-12-04 14:03:37  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>same with phycianlistener
 * <br>
 * <br>Revision 1.1  2007-11-30 14:25:14  heinemann
 * <br>initial checkin
 * <br>
 *   
 */
public class TestGlobalHotkeyRegister {

	private AbstractAction hotKeyAction;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		/* ------------------------------------------------------- */
		// default action for testing
		this.hotKeyAction =  buildAction(13);
		/* ------------------------------------------------------- */
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}
	
	/**
	 * 
	 */
	@Test
	public void testAddHotKey() {
		/* ================================================== */
		GlobalHotkeyRegister.clearHotKeys();
		assertTrue(GlobalHotkeyRegister.registerHotKey(13, this.hotKeyAction));
		assertEquals("registered hotkey is not the same for key 13",
						this.hotKeyAction, GlobalHotkeyRegister.getHotKey(13));
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	@Test
	public void testCompareStoredKeys() {
		/* ================================================== */
		assertTrue(GlobalHotkeyRegister.registerHotKey(16, this.hotKeyAction));
		
		// test if different action object for different key
		assertTrue(GlobalHotkeyRegister.registerHotKey(9, buildAction(9)));
		assertNotSame("action for key 9 is same as for key 13", GlobalHotkeyRegister.getHotKey(9),
																GlobalHotkeyRegister.getHotKey(13));
		/* ================================================== */
	}
	
	@Test
	public void testGetUnkownHotKey() {
		/* ================================================== */
		assertNull("Hotkey must be null", GlobalHotkeyRegister.getHotKey(-1));
		/* ================================================== */
	}
	
	
	/**
	 * Insert the same key
	 */
	@Test
	public void testDoubleHotKeyEntry() {
		/* ================================================== */
		GlobalHotkeyRegister.clearHotKeys();
		assertTrue(GlobalHotkeyRegister.registerHotKey(22, this.hotKeyAction));
		assertFalse(GlobalHotkeyRegister.registerHotKey(22, this.hotKeyAction));
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	@Test(expected=NullPointerException.class)
	public void testInsertNull() {
		/* ================================================== */
		GlobalHotkeyRegister.registerHotKey(12, null);
		/* ================================================== */
	}
	
	/**
	 * Unregister Hotkey
	 */
	@Test
	public void testUnregisterHotKey() {
		/* ================================================== */
		assertTrue(GlobalHotkeyRegister.registerHotKey(17, this.hotKeyAction));
		
		assertTrue("Error removing registered hotkey", GlobalHotkeyRegister.unregisterHotKey(17));
		/* ================================================== */
	}
	
	@Test
	public void testUnregisterUnkownHotKey() {
		/* ================================================== */
		assertFalse("Error removing unregistered hotkey", GlobalHotkeyRegister.unregisterHotKey(12));
		/* ================================================== */
	}
	
	@Test
	public void testClearHotKeys() {
		/* ================================================== */
		GlobalHotkeyRegister.registerHotKey(34, buildAction(34));
		GlobalHotkeyRegister.clearHotKeys();
		assertSame("hotkeys not empty after clear.", 0, GlobalHotkeyRegister.getHotKeysSize());
		/* ================================================== */
	}
	
	
	/**
	 * Test if there are keys when we register a hotkey
	 */
	@Test 
	public void testGetAllHotKeyKeys() {
		/* ================================================== */
		GlobalHotkeyRegister.clearHotKeys();
		RegistrationDesk.registerHotKey(13, this.hotKeyAction);
		assertSame("Keyset size unequal to expected amount: 1", 1, GlobalHotkeyRegister.getHotKeyKeys().size());
		
		// test two actions
		RegistrationDesk.registerHotKey(55, this.hotKeyAction);
		assertNotSame("Keyset size equal to expected amount: 1", 1, GlobalHotkeyRegister.getHotKeyKeys().size());
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	@Test
	public void testGetAllHotKeyActions() {
		/* ================================================== */
		GlobalHotkeyRegister.clearHotKeys();
		GlobalHotkeyRegister.registerHotKey(13, this.hotKeyAction);
		GlobalHotkeyRegister.registerHotKey(14, this.hotKeyAction);
		assertSame("unequal amount of actions", 2, GlobalHotkeyRegister.getAllHotKeyActions().size());
		/* ================================================== */
	}
	
	
	private AbstractAction buildAction(int key) {
		/* ================================================== */
		return new GECAMedAction(null,
				"pm.copyfrompatient",
				null,
				key,
				true,
				true,
				false) {

				private static final long serialVersionUID = 1L;
				
				public void actionPerformed(ActionEvent e)
				{
					
				}
		};
		/* ================================================== */
	}
	
}
