/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.swing.text.MaskFormatter;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
  * The AccidentNumberFormatter is a mask formatter for Accident Numbers as
  * they are defined in Luxembourg. An accident number in Luxembourg is
  * formatted as follows Uyyyy/xxxxx, where yyyy is the year of the accident
  * and xxxxx is a unique number of the accident for that year.
  * @author nico.mack@tudor.lu
 */

public class AccidentNumberFormatter extends MaskFormatter                                                              
    {
    private static final long serialVersionUID = 1L;
     
    public static final String c_EmptyField = "-----/-----";
    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public AccidentNumberFormatter() 
    {
	try {
		this.setMask("U####/#####");
		} 
    catch (ParseException p_Exception) 
        {
    		//Can be safely ignored here.
        }
    
    this.setAllowsInvalid(false);
    this.setValidCharacters("UL0123456789");
    this.setPlaceholderCharacter('-');
    this.setOverwriteMode(true);
    this.setValueContainsLiteralCharacters(true);
    this.setCommitsOnValidEdit(false);
    }
 
//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * Given an accident date, the getAccidentNumber method returns an accident
 * number template where the first section of the number, i.e. the U followed
 * by the year, is properly set.
 * @param p_Date specifies the accident date to get a number for.
 * @return a partially filled accident number template.
 */
//---------------------------------------------------------------------------

public static String getAccidentNumber (Date p_Date)
	{
	GregorianCalendar	l_YearOfAccident;
	int					l_Year;
	String				l_Template;

	if (p_Date == null) return AccidentNumberFormatter.c_EmptyField;

	l_YearOfAccident = new GregorianCalendar ();
	l_YearOfAccident.setTime(p_Date);
	l_Year = l_YearOfAccident.get(Calendar.YEAR);
	l_Template = "U" + l_Year + AccidentNumberFormatter.c_EmptyField.substring(5);

	return (l_Template);
	}

//---------------------------------------------------------------------------

public Object stringToValue (String p_AccidentNumber)
	{
	return p_AccidentNumber;
	}

//---------------------------------------------------------------------------

public String valueToString (Object p_Value)
	{
	return (String) p_Value;
	}

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

