package lu.tudor.santec.gecamed.core.utils;

import java.io.Serializable;

import lu.tudor.santec.gecamed.billing.gui.config.BillingAdminSettingsPlugin;
import lu.tudor.santec.gecamed.billing.utils.BillingAdminSettings;




public abstract class BaseFormatter implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	public static final int ORIGINAL 			= BillingAdminSettings.c_OriginalStyle;
	public static final int CAPITALIZE_WORDS 	= BillingAdminSettings.c_CapitalizeWordStyle;
	public static final int ALL_UPPERCASE 		= BillingAdminSettings.c_UpperCaseStyle;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	protected Integer printMode;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public BaseFormatter(Integer printMode)
	{
		this.printMode = printMode;
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	/**
	 * sets the print mode applicable for formatting methods.
	 * @param printMode specifies the applicable print mode. Possible values are:
	 * <ul>
	 * <li>ORIGINAL: address fields will be printed as is.
	 * <li>CAPITALIZEWORDS: first character of every word in address fields will
	 * be printed in capital letters.
	 * <li>ALLUPPERCASE: every address field will be printed in uppercase letters.
	 * <ul>
	 */
	public void setPrintMode (Integer printMode) 
	{
		if ((printMode >= ORIGINAL) && (printMode <= ALL_UPPERCASE))
			this.printMode = printMode;
	}
	
	
	/**
	 * returns the print mode which is currently set.
	 * @return the currently applicable print mode. Possible values are:
	 * <ul>
	 * <li>ORIGINAL: address fields will be printed as is.
	 * <li>CAPITALIZEWORDS: first character of every word in address fields will
	 * printed in capital letters.
	 * <li>ALLUPPERCASE: every address field will be printed in uppercase letters.
	 * <ul>
	 * @see #setPrintMode()
	 */
	public Integer getPrintMode () 
	{
		return printMode;
	}
}
