/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils;

import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.SimpleLayout;

public class Logger
	{
	private Category m_Logger = Category.getInstance (Logger.class.getName());
	
	private static SimpleLayout m_Layout = new SimpleLayout ();
	private static ConsoleAppender m_Appender = new ConsoleAppender( m_Layout );
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Logger (Class p_ExtendingClass)
	{
	this.setLoggerForClass(p_ExtendingClass);	
	m_Logger.addAppender(m_Appender);
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * writes the specified message with the specified log level into the log
 * file.
 * @param p_Level specifies the log level the specified message should have.
 * @param p_Message specifies the message to be written to log file.
 */
//---------------------------------------------------------------------------

public void log (Level p_Level, String p_Message)
	{
	this.log (p_Level,p_Message,null);
	}

//---------------------------------------------------------------------------
/**
 * writes the specified message with the specified log level into the log
 * file. The stack trace of the specified exception will be logged to.
 * @param p_Level specifies the log level the specified message should have.
 * @param p_Message specifies the message to be written to log file.
 * @param p_Exception specifies the exception to log stack trace of.
 */
//---------------------------------------------------------------------------

public void log (Level p_Level, String p_Message, Exception p_Exception)
	{
	StackTraceElement[] l_StackTrace; 
	String				l_MethodName;
		                  
	l_StackTrace = new Throwable().getStackTrace();
	l_MethodName = l_StackTrace[1].getMethodName();
		
	if (l_MethodName.equals("log")) l_MethodName = l_StackTrace[2].getMethodName();
	p_Message = "\n" + l_MethodName + " => " + p_Message;
			
	if (p_Exception != null) m_Logger.log (p_Level,p_Message,p_Exception);
						else m_Logger.log (p_Level,p_Message);
	}

//---------------------------------------------------------------------------
/**
 * sets the logger for the specified class.
 * @param p_ExtendingClass specfies the extending class to set logger for.
 */
//---------------------------------------------------------------------------

protected void setLoggerForClass (Class p_ExtendingClass)
	{
	m_Logger = Category.getInstance (p_ExtendingClass.getName());
	}

//---------------------------------------------------------------------------
/**
 * Returns the logger object for this bean.
 * @return the current logger object.
 */
//---------------------------------------------------------------------------

protected Category getLogger ()
	{
	return m_Logger;
	}

//---------------------------------------------------------------------------
/**
 * Sets the logger for this bean.
 * @param p_Logger specifies the new logger for this bean.
 */
//---------------------------------------------------------------------------

protected void setLogger (Category p_Logger)
	{
	m_Logger = p_Logger;
	if (m_Logger == null) m_Logger = Category.getInstance (Logger.class.getName());
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
