/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;

/**
 * Class for faster performance tests
 * 
 * @author martin.heinemann@tudor.lu
 * 25.02.2008
 * 12:53:03
 *
 *
 * @version
 * <br>$Log: TimeTracker.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-02-25 15:47:18  heinemann
 * <br>Initial checkin
 * <br>
 *   
 */
public class TimeTracker {
	
	
	private static LinkedHashMap<String, ArrayList<Long>> lapMap = new LinkedHashMap<String, ArrayList<Long>>();
	
	
	/**
	 * 
	 */
	private TimeTracker() {
		/* ================================================== */

		/* ================================================== */
	}
	
	/**
	 * 
	 * @param identifier for the new perfomance race
	 */
	public static void start(String identifier) {
		/* ================================================== */
		ArrayList<Long> laps = new ArrayList<Long>(1);
		laps.add(System.currentTimeMillis());
		lapMap.put(identifier, laps);
		/* ================================================== */
	}
	
	/**
	 * Triggers a lap for the time tracking.
	 * 
	 * @param identifier
	 */
	public static void lapTime(String identifier) {
		/* ================================================== */
		lapTime(identifier, "");
		/* ================================================== */
	}
	
	/**
	 * @param identifier
	 * @param hint text to be placed in the output for simplification
	 */
	public static void lapTime(String identifier, String hint) {
		/* ================================================== */
		ArrayList<Long> laps = lapMap.get(identifier);
		try {
			laps.add(System.currentTimeMillis());
			System.out.println("TimeTrack:: "+identifier +" - " + hint +" : last operation took " 
								+ (laps.get(laps.size()-1) - laps.get(laps.size()-2)) + "ms");
		} catch (Exception e) {
			// is faster than if
			// TODO: handle exception
		}
		/* ================================================== */
	}
	
	/**
	 * Make a last track and clean the hashmap
	 * 
	 * @param identifier
	 */
	public static void finish(String identifier) {
		/* ================================================== */
		lapTime(identifier);
		ArrayList<Long> laps = lapMap.get(identifier);
		System.out.println("TimeTrack:: "+identifier +": Whole process took " 
				+ (laps.get(laps.size()-1) - laps.get(0))+ "ms");
		System.out.println("-------------------------------------------");
		/* ------------------------------------------------------- */
		// make clean
		/* ------------------------------------------------------- */
		lapMap.remove(identifier);
		/* ================================================== */
	}
	
	
}
