package lu.tudor.santec.gecamed.core.utils;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: TimeZoneCheck.java,v $
 * <br>Revision 1.1  2013-05-23 14:27:14  ferring
 * <br>Conflicting time zone detection - changing client time zone to server time zone
 * <br>
 */

public class TimeZoneCheck implements Serializable
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= -2962067881118507484L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */

	private final TimeZone	timeZone;
	
	private final String	timeZoneId;
	
	private int	hour;
	
	private int	minute;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public TimeZoneCheck ()
	{
		this(TimeZone.getDefault());
	}
	
	
	public TimeZoneCheck (TimeZone timeZone)
	{
		this.timeZone	= timeZone;
		this.timeZoneId	= this.timeZone.getID();
		setCheckTime();
	}

	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public void setCheckTime ()
	{
		Calendar	cal	= new GregorianCalendar(this.timeZone);
		
		
		this.hour		= cal.get(Calendar.HOUR_OF_DAY);
		this.minute		= cal.get(Calendar.MINUTE);
	}
	
	
	public TimeZone getTimeZone ()
	{
		return this.timeZone;
	}
	
	
	public String getTimeZoneID ()
	{
		return this.timeZoneId;
	}
	
	
	public int getHour ()
	{
		return this.hour;
	}
	
	
	public int getMinute ()
	{
		return this.minute;
	}
}
