package lu.tudor.santec.gecamed.core.utils;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * Class to work with versions 
 * 
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.12.2008
 * 16:34:03
 *
 *
 * @version
 * <br>$Log: VersionUtils.java,v $
 * <br>Revision 1.5  2013-07-15 06:18:34  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.4  2012-08-08 11:32:28  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2012-04-12 13:50:26  troth
 * <br>Add function to check java version.
 * <br>
 * <br>Revision 1.2  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.1.2.1  2008-12-15 17:16:05  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class VersionUtils {

	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(VersionUtils.class.getName());
	
	
	/**
	 * Compares two version strings in the form xxx.xxx.xxx
	 * 
	 * 
	 * @param v1
	 * @param v2
	 * @return return -1 if v1 < v2, 0 if v1 = v2, 1 if v1 > v2
	 * 
	 */
	private static int compareVersion(String v1, String v2) {
		/* ================================================== */
		// split the version by .
		/* ------------------------------------------------------- */
		long intV1 = parseVersion(v1);
		long intV2 = parseVersion(v2);
		/* ------------------------------------------------------- */
		if (intV1 < intV2)
			return -1;
		if (intV1 > intV2)
			return 1;
		
		return 0;
		/* ================================================== */
	}
	
	
	/**
	 * Wrapper for compareVersion, for simplification
	 * 
	 * @param v1 
	 * @param v2
	 * @return true if v1 is smaller than v2
	 */
	public static boolean isSmaller(String v1, String v2) 
	{
		return compareVersion(v1, v2) == -1;
	}
	
	
	/**
	 * @param version
	 * @return
	 */
	private static long parseVersion(String version) 
	{
		String orgVersion	= version;
		
		version	= version
				.replaceAll("[^\\d\\.]+", ".")	// make dots out of all not-digit and not-dot chars
				.replaceAll("[\\.]+", ".")		// convert a a sequence of dots to a single dot
				.replaceAll("^\\.", "")			// remove the dot at the beginning
				.replaceAll("\\.$", "");		// remove the dot at the end
		
		
		if (!orgVersion.equals(version))
			logger.warn("Version changed for comparing. Original version was \"" + 
					orgVersion + "\", new is \"" + version + "\".");
		
		String[] split = version.split("\\.");
		
		long intVersion = 0;
		
		long offSet = 1000000000000000000l;
		int shift = 1000;
		for (int i = 0; i < split.length; i++) 
		{
			long digit = Integer.parseInt(split[i]);
			
			if (digit > 0)
				intVersion +=  digit * offSet;
			
			offSet /= shift;
		}
		
		return intVersion;
	}
	
	/**
	 * Used for method isJavaVersionOK 
	 */
	private static Boolean javaVersionOK = null;
	
	public static boolean isSmallerJavaVersionThan (int currentJavaVersion)
	{
		if (javaVersionOK == null) 
		{
			// get the java version
			String javaVersion = System.getProperties().getProperty("java.version");
			String[] version = javaVersion.split("\\.");
			
			// check, if the version is higher than 1.6
			if (Integer.parseInt(version[0]) == 1
					&& Integer.parseInt(version[1]) < currentJavaVersion) {
				javaVersionOK = false;
				
				// log that, the java version is not high enough for the form editor
				Logger.getLogger(VersionUtils.class.getName()).log(Level.INFO, "Necessary Java version is 1.6.0 or higher, " +
						"but current Java version is " + javaVersion);
				
			} 
			else 
			{
				javaVersionOK = true;
			}
		}
		
		return javaVersionOK.booleanValue();
	}
	
	
	public static void main(String[] args)
	{
		System.out.println(Long.MAX_VALUE);
		String version = "dfg1.2...04bf0asd3asf";
		System.out.println(version);
		System.out.println(parseVersion(version));
	}
}
