package lu.tudor.santec.gecamed.core.utils.printing.ireport;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.gui.config.BillingAdminSettingsPlugin;
import lu.tudor.santec.gecamed.billing.utils.BillingAdminSettings;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.core.utils.SettingPluginNames;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationClass;
import lu.tudor.santec.gecamed.patient.utils.SettingConstants;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.LoginBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


public class UtilSettings implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	public static final String SETTING_DATE_CREATED 		= "dateCreated";
	public static final String SETTING_IS_DEMO 				= "isDemo";
	public static final String SETTING_IS_COPY 				= "isCopy";	
	public static final String SETTING_SPLIT_BILLING 		= BillingAdminSettings.c_SplitBillingSetting;
	public static final String SETTING_SHORT_INVOICE_NUMBER = BillingAdminSettings.c_ShortInvoiceNumbersSetting;
	public static final String SETTING_USE_LEADING_ZEROS 	= BillingAdminSettings.c_UseLeadingZerosSetting;
	public static final String SETTING_ADDRESS_STYLE 		= BillingAdminSettings.c_AddressStyleSetting;
	public static final String SETTING_CUMULATE_ALL_IF_HOSP	= BillingAdminSettings.c_HospitalizedCumulationMode;
	public static final String SETTING_SETTLEMENT_VERIFICATION_DATE = "settlementVerificationDate";
	public static final String SETTING_TOTAL_AMOUNT 		= "totalAmount";
	public static final String SETTING_INVOICE_COUNT 		= "invoiceCount";
	public static final String SETTING_PHYSICIAN_WITH_TITLE	= SettingConstants.PHYSICIAN_WITH_TITLE;
	public static final String SETTING_PHYSICIAN_SWITCH_NAMES	= SettingConstants.PHYSICIAN_SWITCH_NAMES;
	public static final String SETTING_PHYSICIAN_WITH_COMMA	= SettingConstants.PHYSICIAN_WITH_COMMA;
	
	
	public static final Integer	ORIGINAL 	= BillingAdminSettings.c_OriginalStyle;	
	public static final Integer	CAPITALIZE 	= BillingAdminSettings.c_CapitalizeWordStyle;
	public static final Integer	UPPER_CASE 	= BillingAdminSettings.c_UpperCaseStyle;	

	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(UtilSettings.class.getName());
	
	private HashMap<String, Object> settings;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	/**
	 * Use the class UtilFormatter, to construct a new instance
	 */
	UtilSettings () 
	{
		settings = new HashMap<String, Object>();
		
		try 
		{
			LoginInterface login = (LoginInterface) ManagerFactory.getRemote(LoginBean.class);
//			SettingReader reader = login.getAdminSettingsReader();
			
//			reader.getValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, )
			
			putSetting(SETTING_IS_DEMO, 				GECAMedUtils.isDemo());
			putSetting(SETTING_IS_COPY, 				Boolean.FALSE);
			
			putSetting(SETTING_SPLIT_BILLING, 			login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, SETTING_SPLIT_BILLING), 		BillingAdminSettingsPlugin.c_SplitBillingStationary);
			putSetting(SETTING_SHORT_INVOICE_NUMBER, 	login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, SETTING_SHORT_INVOICE_NUMBER),	BillingAdminSettingsPlugin.c_ShortInvoiceNumbersStationary);
			putSetting(SETTING_USE_LEADING_ZEROS, 		login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, SETTING_USE_LEADING_ZEROS), 	BillingAdminSettingsPlugin.c_UseLeadingZerosStationary);
			putSetting(SETTING_ADDRESS_STYLE, 			login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, SETTING_ADDRESS_STYLE), 		BillingAdminSettingsPlugin.c_AddressStyleStationary);
			putSetting(SETTING_CUMULATE_ALL_IF_HOSP,	login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, SETTING_CUMULATE_ALL_IF_HOSP),	BillingAdminSettingsPlugin.c_HospitalizedCumulationStationary);
			putSetting(BillingAdminSettings.c_PrintCNSCodeSetting,	login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, BillingAdminSettings.c_PrintCNSCodeSetting),	BillingAdminSettings.c_PrintPhysicianCNSNoStationary);
			putSetting(BillingAdminSettings.c_PrintZeroActsSetting,			login.getAdminSettingValue(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME, BillingAdminSettings.c_PrintZeroActsSetting),		BillingAdminSettings.c_PrintZeroActsStationary);
			
			putSetting(SETTING_PHYSICIAN_WITH_TITLE,	login.getAdminSettingValue(SettingPluginNames.PATIENT_ADMIN_ELEM_PLUGIN_NAME, SETTING_PHYSICIAN_WITH_TITLE),	Boolean.TRUE);
			putSetting(SETTING_PHYSICIAN_SWITCH_NAMES,	login.getAdminSettingValue(SettingPluginNames.PATIENT_ADMIN_ELEM_PLUGIN_NAME, SETTING_PHYSICIAN_SWITCH_NAMES),	Boolean.FALSE);
			putSetting(SETTING_PHYSICIAN_WITH_COMMA,	login.getAdminSettingValue(SettingPluginNames.PATIENT_ADMIN_ELEM_PLUGIN_NAME, SETTING_PHYSICIAN_WITH_COMMA),	Boolean.FALSE);
		}
		catch (Exception e)
		{
			putSetting(SETTING_IS_DEMO, 				Boolean.TRUE);
			putSetting(SETTING_IS_COPY, 				Boolean.FALSE);
			putSetting(SETTING_SPLIT_BILLING, 			Boolean.TRUE);
			putSetting(SETTING_SHORT_INVOICE_NUMBER, 	Boolean.FALSE);
			putSetting(SETTING_USE_LEADING_ZEROS, 		Boolean.TRUE);
			putSetting(SETTING_ADDRESS_STYLE, 			Integer.valueOf(2));
			putSetting(SETTING_PHYSICIAN_WITH_TITLE,	Boolean.TRUE);
			putSetting(SETTING_PHYSICIAN_SWITCH_NAMES,	Boolean.FALSE);
			putSetting(SETTING_PHYSICIAN_WITH_COMMA,	Boolean.FALSE);
			putSetting(BillingAdminSettings.c_PrintCNSCodeSetting,	BillingAdminSettings.c_PrintPhysicianCNSNoStationary);
			putSetting(BillingAdminSettings.c_PrintZeroActsSetting,			BillingAdminSettings.c_PrintZeroActsStationary);
			logger.warn(e.getMessage());
		}
	}
	
	
	
	/* ======================================== */
	// 		SETTINGS METHODS
	/* ======================================== */
	
	public void putSetting (String key, Object value, Object defaultValue)
	{
		if (value != null)
			 settings.put(key, value);
		else settings.put(key, defaultValue);
		
		if (value == null)
			logger.log(Level.WARN, "The value for \""+key+"\" was null! Therefor set to \""+defaultValue+"\".");
	}
	
	
	public void putSetting (String key, Object value)
	{
		putSetting(key, value, null);
	}
	
	
	public Object getSetting (String key)
	{
		return settings.get(key);
	}
	
	
	/* ---------------------------------------- */
	// 		BOOLEAN
	/* ---------------------------------------- */
	
	public Boolean isDemo ()
	{
		return (Boolean) settings.get(SETTING_IS_DEMO);
	}
	
	
	public Boolean isCopy ()
	{
		return (Boolean) settings.get(SETTING_IS_COPY);
	}
	
	
	public Boolean splitBilling ()
	{
		return (Boolean) settings.get(SETTING_SPLIT_BILLING);
	}
	
	
	public Boolean useShortInvoiceNumber ()
	{
		return (Boolean) settings.get(SETTING_SHORT_INVOICE_NUMBER);
	}
	
	
	public Boolean useLeadingZeros ()
	{
		return (Boolean) settings.get(SETTING_USE_LEADING_ZEROS);
	}
	
	
	public Boolean printCapitalizedAddress ()
	{
		return settings.get(SETTING_ADDRESS_STYLE).equals(CAPITALIZE) ? Boolean.TRUE : Boolean.FALSE;
	}
	
	
	public Boolean printOriginalAddress ()
	{
		return settings.get(SETTING_ADDRESS_STYLE).equals(ORIGINAL) ? Boolean.TRUE : Boolean.FALSE;
	}
	
	
	public Boolean printUpperCaseAddress ()
	{
		return settings.get(SETTING_ADDRESS_STYLE).equals(UPPER_CASE) ? Boolean.TRUE : Boolean.FALSE;
	}
	
	
	public Boolean cumulateAllActsOfFirst2Days (Invoice invoice)
	{
		String hospitalizationClass = invoice.getHospitalisationClass() == null ? null : invoice.getHospitalisationClass().getName();
		
		if (hospitalizationClass == null)
			hospitalizationClass = HospitalisationClass.c_Ambulant;
		
		return hospitalizationClass.equals(HospitalisationClass.c_FirstClass)
				|| hospitalizationClass.equals(HospitalisationClass.c_SecondClass);
	}
	
	
	/* ---------------------------------------- */
	// 		NUMBER
	/* ---------------------------------------- */
	
	public Integer getAddressStyle ()
	{
		return (Integer) settings.get(SETTING_ADDRESS_STYLE);
	}
	
	
	public Double getTotalAmount ()
	{
		return (Double) settings.get(SETTING_TOTAL_AMOUNT);
	}
	
	
	public Integer getInvoiceCount ()
	{
		return (Integer) settings.get(SETTING_INVOICE_COUNT);
	}
	
	
	/* ---------------------------------------- */
	// 		DATE
	/* ---------------------------------------- */
	
	public Date getSettlementVerificationDate ()
	{
		return (Date) getSetting(SETTING_SETTLEMENT_VERIFICATION_DATE);
	}
	
	
	public Date getDateCreated ()
	{
		return (Date) getSetting(SETTING_DATE_CREATED);
	}
	
	
	/**
	 * @return a new Date representing the moment, the method is called.
	 */
	public Date getNow ()
	{
		return new Date();
	}
	
	
	public boolean printPhysicanCNSCode ()
	{
		return ((Boolean) getSetting(BillingAdminSettings.c_PrintCNSCodeSetting)).booleanValue();
	}
}