/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils.querybuilder;

import java.util.Hashtable;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * The HibernateOperator class defines comparison operators for hibernate queries.
 * 
 * @author nico.mack@tudor.lu
 */

public class HibernateOperator extends Operator
{
	private static final long serialVersionUID = 1L;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

private static transient final Hashtable <Integer,String> m_OperatorLookup = new Hashtable <Integer,String> ();
	
static	{
		m_OperatorLookup.put(Operator.c_LowerThan, 		" < ");
		m_OperatorLookup.put(Operator.c_LowerOrEqual, 	" <= ");
		m_OperatorLookup.put(Operator.c_Equal, 			" = ");
		m_OperatorLookup.put(Operator.c_NotEqual, 		" <> ");
		m_OperatorLookup.put(Operator.c_GreaterOrEqual, " >= ");
		m_OperatorLookup.put(Operator.c_GreaterThan, 	" > ");
		m_OperatorLookup.put(Operator.c_Like, 			" LIKE ");
		m_OperatorLookup.put(Operator.c_NotLike, 		" NOT LIKE ");
		m_OperatorLookup.put(Operator.c_And, 			" AND ");
		m_OperatorLookup.put(Operator.c_Or, 			" OR ");
		m_OperatorLookup.put(Operator.c_Is, 			" IS ");
		m_OperatorLookup.put(Operator.c_IsNot, 			" IS NOT ");
		m_OperatorLookup.put(Operator.c_In, 			" IN ");
		m_OperatorLookup.put(Operator.c_NotIn, 			" NOT IN ");
		}

	public static final HibernateOperator c_LowerThanOperator 		= new HibernateOperator (c_LowerThan);
	public static final HibernateOperator c_LowerOrEqualOperator 	= new HibernateOperator (c_LowerOrEqual);
	public static final HibernateOperator c_EqualOperator 			= new HibernateOperator (c_Equal);
	public static final HibernateOperator c_NotEqualOperator 		= new HibernateOperator (c_NotEqual);
	public static final HibernateOperator c_GreaterOrEqualOperator 	= new HibernateOperator (c_GreaterOrEqual);
	public static final HibernateOperator c_GreaterThanOperator 	= new HibernateOperator (c_GreaterThan);
	public static final HibernateOperator c_LikeOperator 			= new HibernateOperator (c_Like);
	public static final HibernateOperator c_NotLikeOperator 		= new HibernateOperator (c_NotLike);
	public static final HibernateOperator c_AndOperator 			= new HibernateOperator (c_And);
	public static final HibernateOperator c_OrOperator 				= new HibernateOperator (c_Or);
	public static final HibernateOperator c_IsOperator 				= new HibernateOperator (c_Is);
	public static final HibernateOperator c_IsNotOperator 			= new HibernateOperator (c_IsNot);
	public static final HibernateOperator c_InOperator 				= new HibernateOperator (c_In);
	public static final HibernateOperator c_NotInOperator 			= new HibernateOperator (c_NotIn);

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructors                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

public HibernateOperator (int p_Operator)
	{
	this.setOperator (p_Operator);	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Renders the hibernate specific representation of this operator
 * @return Hibernate specific representation of this operator
 */
//---------------------------------------------------------------------------

public String toString ()
	{
	if (m_OperatorLookup.containsKey(this.getOperator()))
		 return m_OperatorLookup.get(this.getOperator());
	else return "";
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}
