/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils.querybuilder;

import java.io.Serializable;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * The Operator class defines a generic comparison operator for queries.
 * 
 * @author nico.mack@tudor.lu
 */

public class Operator implements Serializable
	{

	private static final long serialVersionUID = 1L;

	private Integer	m_Operator;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	public static final int		c_None				= 0;
	public static final int		c_LowerThan			= 1;
	public static final int		c_LowerOrEqual		= 2;		
	public static final int		c_Equal				= 3;		
	public static final int		c_NotEqual			= 4;		
	public static final int		c_GreaterOrEqual	= 5;		
	public static final int		c_GreaterThan		= 6;		
	public static final int		c_Like				= 7;
	public static final int		c_NotLike			= 8;
	public static final int		c_And				= 9;
	public static final int		c_Or				= 10;
	public static final int		c_Is				= 11;
	public static final int		c_IsNot				= 12;
	public static final int		c_In				= 13;
	public static final int		c_NotIn				= 14;

	private static final int	c_OperatorCount		= 15;
	
	public static final Operator c_LowerThanOperator 		= new Operator (c_LowerThan);
	public static final Operator c_LowerOrEqualOperator 	= new Operator (c_LowerOrEqual);
	public static final Operator c_EqualOperator 			= new Operator (c_Equal);
	public static final Operator c_NotEqualOperator 		= new Operator (c_NotEqual);
	public static final Operator c_GreaterOrEqualOperator 	= new Operator (c_GreaterOrEqual);
	public static final Operator c_GreaterThanOperator 		= new Operator (c_GreaterThan);
	public static final Operator c_LikeOperator 			= new Operator (c_Like);
	public static final Operator c_NotLikeOperator 			= new Operator (c_NotLike);
	public static final Operator c_AndOperator 				= new Operator (c_And);
	public static final Operator c_OrOperator 				= new Operator (c_Or);
	public static final Operator c_IsOperator 				= new Operator (c_Is);
	public static final Operator c_IsNotOperator 			= new Operator (c_IsNot);
	public static final Operator c_InOperator 				= new Operator (c_In);
	public static final Operator c_NotInOperator 			= new Operator (c_NotIn);
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructors                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

public Operator ()
	{
	m_Operator = Integer.valueOf(c_None);
	}
	
//---------------------------------------------------------------------------

public Operator (int p_Operator)
	{
	this.setOperator (p_Operator);	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public void setOperator (int p_Operator)
	{
	if ((p_Operator >= c_None) && (p_Operator < c_OperatorCount))
		 m_Operator = Integer.valueOf(p_Operator);
	else m_Operator = Integer.valueOf(c_None);	
	}
	
//---------------------------------------------------------------------------

public int getOperator ()
	{
	return m_Operator;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
