/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.ejb.entity.beans;

import java.awt.Image;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity bean that represents an DCM Series in the database
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: DCMSeries.java,v $
 * <br>Revision 1.7  2013-06-27 13:40:23  ferring
 * <br>dicom viewer updated
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-04-08 13:15:32  hermen
 * <br>added dicom entry to medical history
 * <br>
 * <br>Revision 1.4  2008-03-10 13:50:08  hermen
 * <br>updated preview image handling
 * <br>
 * <br>Revision 1.3  2008-03-05 07:27:39  hermen
 * <br>a lot of improvements and bugfixes
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name=DCMSeries.findAllDCMSeries,
        query="SELECT OBJECT(o) FROM DCMSeries o"),
    @javax.persistence.NamedQuery(name=DCMSeries.findAllDCMSeriesByStudyID,
        query="SELECT OBJECT(o) FROM DCMSeries o WHERE o.studyID = :studyID ORDER BY o.number  ASC"),
    @javax.persistence.NamedQuery(name=DCMSeries.findDCMSeriesByInstanceUID,
        query="SELECT OBJECT(o) FROM DCMSeries o WHERE o.instanceUID = :instanceUID")
})


@Entity
@Table(schema="dicom", name="series")
public class DCMSeries extends GECAMedEntityBean implements Serializable, DCMEntry {

	private static final long serialVersionUID = 1L;
	
	public static final String findAllDCMSeries = "findAllDCMSeries";
	public static final String findAllDCMSeriesByStudyID = "findAllDCMSeriesByStudyID";
	public static final String findDCMSeriesByInstanceUID = "findDCMSeriesByInstanceUID";
	
	/**
	 * reference to DCM Study  
	 */
	private Integer studyID;
	
	/**
	 * reference to incident entry  
	 */
	private Integer incidentEntryID;
	
	/**
	 * dcm tag 0020,000E Series Instance UID
	 */
	private String instanceUID;
	
	/**
	 * dcm tag 0020,0011 Series Number
	 */
	private Integer number;
	
	/**
	 *  dcm tag 0008,103E Series Desc.
	 */
	private String description;
	
	/**
	 * dcm tag 0008,0060 Modality
	 */
	private String modality;
	
	/**
	 * dcm tag 0018,1030 Protocol
	 */
	private String protocol;

	
	/**
	 * dcm tag 0008,0090 refering physician
	 */
	private String physician;
	
	/**
	 * dcm tags 0008,0021+0008,0031 Series Date/Time
	 */
	private Date 	date;

	private String imageInfos = "";

	private Vector<DCMEntry> childs;

	private byte[] preview;

	
	private transient ImageIcon previewIcon;
	
	/**
	 * @return the modality
	 */
	@javax.persistence.Column(name = "modality")
	public java.lang.String getModality() {
		return modality;
	}

	/**
	 * @param modality the modality to set
	 */
	public void setModality(String modality) {
		this.modality = modality;
	}

	/**
	 * @return the protocol
	 */
	@javax.persistence.Column(name = "protocol")
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol the protocol to set
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}
	
	/**
	 * @return the physician
	 */
	@javax.persistence.Column(name = "physician")
	public String getPhysician() {
		return physician;
	}

	/**
	 * @param physician the physician to set
	 */
	public void setPhysician(String physician) {
		this.physician = physician;
	}
	
	/**
	 * @return the date
	 */
	@javax.persistence.Column(name = "date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the description
	 */
	@javax.persistence.Column(name = "description")
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the instanceUID
	 */
	@javax.persistence.Column(name = "instance_uid")
	public String getInstanceUID() {
		return instanceUID;
	}

	/**
	 * @param instanceUID the instanceUID to set
	 */
	public void setInstanceUID(String instanceUID) {
		this.instanceUID = instanceUID;
	}

	/**
	 * @return the series number
	 */
	@javax.persistence.Column(name = "number")
	public Integer getNumber() {
		return number;
	}

	/**
	 * @param number the number to set
	 */
	public void setNumber(Integer number) {
		this.number = number;
	}

	/**
	 * @return the studyID
	 */
	@javax.persistence.Column(name = "study_id")
	public Integer getStudyID() {
		return studyID;
	}

	/**
	 * @param studyID the studyID to set
	 */
	public void setStudyID(Integer studyID) {
		this.studyID = studyID;
	}
	
	/**
	 * @return the incidentEntryID
	 */
	@javax.persistence.Column(name = "incident_entry_id")
	public Integer getIncidentEntryID() {
	    return incidentEntryID;
	}

	/**
	 * @param incidentEntryID the incidentEntryID to set
	 */
	public void setIncidentEntryID(Integer incidentEntryID) {
	    this.incidentEntryID = incidentEntryID;
	}

    
	@Transient
	public int getEntryType() {
		return SERIES;
	}
	
	@Transient
	public String getImageInfos() {
		return imageInfos;
	}
	
	@Transient
	public void setImageInfos(String imageInfos) {
		this.imageInfos = imageInfos;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getChildCount()
	 */
	@Transient
	public int getChildCount() {
		if (this.childs != null)
			return this.childs.size();
		return 0;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getChilds()
	 */
	@Transient
	public Vector<DCMEntry> getChilds() {
		return this.childs;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#setChilds(java.util.Vector)
	 */
	@Transient
	public void setChilds(Vector<DCMEntry> childs) {
		this.childs = childs;
	}

	@Transient
	public void setPreview(byte[] preview) {
		this.preview = preview;
	}
	
	@Transient
	public byte[] getPreview() {
		return this.preview;
	}
	
	@Transient
	public ImageIcon getPreviewIcon() {
		if (previewIcon == null && preview != null) {
			this.previewIcon = new ImageIcon(
					new ImageIcon(preview).getImage()
						.getScaledInstance(32, 32, Image.SCALE_DEFAULT));
		}
		return this.previewIcon;
	}
	
    
}
