/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity bean that represents an DCM Study in the database
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: DCMStudy.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-04-08 13:15:32  hermen
 * <br>added dicom entry to medical history
 * <br>
 * <br>Revision 1.3  2008-03-05 07:27:39  hermen
 * <br>a lot of improvements and bugfixes
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name=DCMStudy.findAllDCMStudy,
        query="SELECT OBJECT(o) FROM DCMStudy o"),
    @javax.persistence.NamedQuery(name=DCMStudy.findDCMStudiesByPatientID,
        query="SELECT OBJECT(o) FROM DCMStudy o WHERE o.patientID = :patientID ORDER BY o.date DESC"),
    @javax.persistence.NamedQuery(name=DCMStudy.findDCMStudyByInstanceUID,
        query="SELECT OBJECT(o) FROM DCMStudy o WHERE o.instanceUID = :instanceUID")
})


@Entity
@Table(schema="dicom", name="study")
public class DCMStudy extends GECAMedEntityBean implements Serializable, DCMEntry {

	private static final long serialVersionUID = 1L;

	public static final String findAllDCMStudy = "findAllDCMStudy";
	public static final String findDCMStudiesByPatientID = "findAllDCMStudyByPatientID";
	public static final String findDCMStudyByInstanceUID = "findDCMStudyByInstanceUID";
	
	/**
	 * reference to Patient.Patient 
	 */
	private Integer patientID;
	
	/**
	 * reference to incident entry  
	 */
	private Integer incidentEntryID;
	
	/**
	 * dcm tag  0020,000D Study Instance UID
	 */
	private String instanceUID;
	
	/**
	 *  dcm tag 0020,0010 Study ID
	 */
	private Integer number;
	
	/**
	 * dcm tag 0008,1030 Study Desc. 
	 */
	private String description;
	
	/**
	 *  dcm tag 0008,0080 Institution Name
	 */
	private String institution;
	
	/**
	 * dcm tags 0008,0020+0008,0030 Study Date/Time
	 */
	private Date 	date;

	private Vector<DCMEntry> childs;
	
	/**
	 * @return the patientID
	 */
	@javax.persistence.Column(name = "patient_id")
	public java.lang.Integer getPatientID() {
		return patientID;
	}

	/**
	 * @param patientID the patientID to set
	 */
	public void setPatientID(Integer patientID) {
		this.patientID = patientID;
	}

	/**
	 * @return the date
	 */
	@javax.persistence.Column(name = "date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the description
	 */
	@javax.persistence.Column(name = "description")
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the instanceUID
	 */
	@javax.persistence.Column(name = "instance_uid")
	public String getInstanceUID() {
		return instanceUID;
	}

	/**
	 * @param instanceUID the instanceUID to set
	 */
	public void setInstanceUID(String instanceUID) {
		this.instanceUID = instanceUID;
	}

	/**
	 * @return the institution
	 */
	@javax.persistence.Column(name = "institution")
	public String getInstitution() {
		return institution;
	}

	/**
	 * @param institution the institution to set
	 */
	public void setInstitution(String institution) {
		this.institution = institution;
	}

	/**
	 * @return the number
	 */
	@javax.persistence.Column(name = "number")
	public Integer getNumber() {
		return number;
	}

	/**
	 * @param number the number to set
	 */
	public void setNumber(Integer number) {
		this.number = number;
	}
	
	/**
	 * @return the incidentEntryID
	 */
	@javax.persistence.Column(name = "incident_entry_id")
	public Integer getIncidentEntryID() {
	    return incidentEntryID;
	}

	/**
	 * @param incidentEntryID the incidentEntryID to set
	 */
	public void setIncidentEntryID(Integer incidentEntryID) {
	    this.incidentEntryID = incidentEntryID;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getEntryType()
	 */
	@Transient
	public int getEntryType() {
		return STUDY;
	}

	@Transient
	public String getModality() {
		return "";
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getChildCount()
	 */
	@Transient
	public int getChildCount() {
		if (this.childs != null)
			return this.childs.size();
		return 0;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getChilds()
	 */
	@Transient
	public Vector<DCMEntry> getChilds() {
		return this.childs;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#setChilds(java.util.Vector)
	 */
	@Transient
	public void setChilds(Vector<DCMEntry> childs) {
		this.childs = childs;
	}
}
