/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.ejb.session.interfaces;

import java.util.Collection;
import java.util.Vector;

import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry;
import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMImage;
import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMSeries;
import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMStudy;

public interface DCMManagerInterface {

	/**
	 * returns all DCMStudies for the supplied patient ID
	 * @param patientID
	 * @return
	 * @throws Exception
	 */
	public Collection<DCMStudy> getStudies(Integer patientID) throws Exception;
	
	/**
	 * returns all DCMSeries for the supplied study ID
	 * @param studyID
	 * @return
	 * @throws Exception
	 */
	public Collection<DCMSeries> getSeries(Integer studyID) throws Exception;
	
	/**
	 * returns all DCMImages for the supplied series ID
	 * @param seriesID
	 * @return
	 * @throws Exception
	 */
	public Collection<DCMImage> getImages(Integer seriesID) throws Exception;
	
	/**
	 * saved the supplied study
	 * @param study
	 * @return
	 * @throws Exception
	 */
	public DCMStudy saveStudy(DCMStudy study) throws Exception;
	
	/**
	 * saved the supplied series
	 * @param series
	 * @return
	 * @throws Exception
	 */
	public DCMSeries saveSeries(DCMSeries series) throws Exception;
	
	/**
	 * saved the supplied image
	 * @param image
	 * @param file
	 * @return
	 * @throws Exception
	 */
	public DCMImage saveImage(DCMImage image, byte[] file) throws Exception;
	
	/**
	 * returns the study for the supplied instnaceUID
	 * @param instanceUID
	 * @return
	 * @throws Exception
	 */
	public DCMStudy getStudy(String instanceUID) throws Exception;
	
	/**
	 * returns the series for the supplied instnaceUID
	 * @param instanceUID
	 * @return
	 * @throws Exception
	 */
	public DCMSeries getSeries(String instanceUID) throws Exception;
	
	/**
	 * returns the image for the supplied instnaceUID
	 * @param instanceUID
	 * @return
	 * @throws Exception
	 */
	public DCMImage getImage(String instanceUID) throws Exception;

	/**
	 * returns the patients dicom history as a tree of entries
	 * @param patientID
	 * @return
	 * @throws Exception
	 */
	public Vector<DCMEntry> getDCMHistoryTree(Integer patientID) throws Exception;
	
	/**
	 * returns the dicom fiel for the supplied dcmimage
	 * @param image
	 * @return
	 * @throws Exception
	 */
	public byte[] getImageFile(DCMImage image) throws Exception;
	
	/**
	 * deletes the provided study
	 * @param study
	 * @throws Exception
	 */
	public void deleteStudy(DCMStudy study) throws Exception;
	
	/**
	 * deletes the provided series
	 * @param series
	 * @throws Exception
	 */
	public void deleteSeries(DCMSeries series) throws Exception;
}
