/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.gui;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;

import javax.swing.JDialog;
import javax.swing.JFrame;

import lu.tudor.santec.dicom.gui.viewer.DicomImageAngleMeasurement;
import lu.tudor.santec.dicom.gui.viewer.DicomImageInverter;
import lu.tudor.santec.dicom.gui.viewer.DicomImageMeasurement;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;
import lu.tudor.santec.dicom.gui.viewer.SeriesBar;
import lu.tudor.santec.dicom.gui.viewer.SliceListener;

import com.l2fprod.common.swing.JButtonBar;

/**
 * Dialog to show Dicom Images with an imagepanel and a series bar.  
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: DCMImageDialog.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-07-10 08:59:17  hermen
 * <br>changed saving of dicom files
 * <br>
 * <br>Revision 1.2  2008-04-03 14:14:22  hermen
 * <br>fixed image loading
 * <br>
 * <br>Revision 1.1  2008-02-26 10:45:51  hermen
 * <br>initial checkin of the dicom module
 * <br>
 *
 */
public class DCMImageDialog extends JDialog implements SliceListener{
	
	private static final long serialVersionUID = 1L;
	private DicomImagePanel imagePanel;
	private DicomImagePanel imageArea;
	private SeriesBar seriesBar;
	
	/**
	 * creates a new dialog
	 * @param parent
	 */
	public DCMImageDialog(JFrame parent) {
		super(parent);
		this.setLayout(new BorderLayout());
		
		imageArea = new DicomImagePanel(10, 10, true, false,false);
		imagePanel = imageArea.createBigArea();
		imagePanel.setSliceListener(this);
		imagePanel.setImageSize(600,600);
		imagePanel.setShowDicomInfos(true);
		new DicomImageMeasurement(imageArea);
		new DicomImageAngleMeasurement(imageArea);
		new DicomImageInverter(imageArea);
		this.add(imagePanel, BorderLayout.CENTER);
		this.add(imagePanel.createToolBar(), BorderLayout.WEST);
		
		this.seriesBar = new SeriesBar(JButtonBar.VERTICAL,96, this.imagePanel.parentPanel, false);
		this.add(this.seriesBar, BorderLayout.EAST);
		
		this.pack();
	}
	
	/**
	 * clear all loaded series and images 
	 */
	public void clear() {
		this.seriesBar.removeallSeries();
		this.imageArea.setImage(null);
		this.imagePanel.setImage(null);
	}

	
	/**
	 * load the images from the File[]
	 * @param fArr
	 */
	public void showImages(File[] fArr) {
		this.seriesBar.addSeries(fArr);
		this.setVisible(true);
	}
	
	/**
	 * load the images from the byte[] collection
	 * @param imgBytes
	 */
	public void showImages(Collection<byte[]> imgBytes) {
		this.seriesBar.addSeries(imgBytes, true);
		this.setVisible(true);
	}

	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.dicom.gui.viewer.SliceListener#nextSlice()
	 */
	public void nextSlice() {
		this.seriesBar.showNextImage();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.dicom.gui.viewer.SliceListener#previousSlice()
	 */
	public void previousSlice() {
		this.seriesBar.showPreviousImage();
	}
	
}
