/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.gui;

import java.awt.Component;
import java.text.DateFormat;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry;
import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMSeries;
import lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMStudy;
import lu.tudor.santec.i18n.Translatrix;

/**
 * TreeCellRenderer that renders the DCMSeries and DCMStudies in the 
 * Treetable
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: DCMTreeCellRenderer.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-03-12 14:53:51  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-03-05 07:27:39  hermen
 * <br>a lot of improvements and bugfixes
 * <br>
 *
 */
public class DCMTreeCellRenderer extends DefaultTreeCellRenderer{

	private static final long serialVersionUID = 1L;
	
	public static final ImageIcon ICON_STUDY = IconFetcher.getIcon(PatientDicomPanel.class, PatientDicomPanel.ICON_STUDY);
	public static final ImageIcon ICON_SERIES = IconFetcher.getIcon(PatientDicomPanel.class, PatientDicomPanel.ICON_SERIES);
	public static final ImageIcon ICON_IMAGE = IconFetcher.getIcon(PatientDicomPanel.class, PatientDicomPanel.ICON_IMAGE);
	
	private DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT, Translatrix.getLocale());
	
	/* (non-Javadoc)
	 * @see javax.swing.tree.DefaultTreeCellRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
	 */
	@Override
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
		
		JLabel comp = (JLabel) super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf,
				row, hasFocus);
		
		comp.setVerticalAlignment(JLabel.CENTER);
		
		DCMEntry node = (DCMEntry) value;
		// if element is a study
		if (node.getEntryType() == DCMEntry.STUDY) {
			comp.setIcon(ICON_STUDY);
			String inst = ((DCMStudy)node).getInstitution();
			if (node.getDate() != null)
				comp.setText("<html><b>" + df.format(node.getDate()) + "</b><br>" + inst);
			else
				comp.setText("<html><b>---" + "</b><br>" + inst);
			
		// if element is a series
		} else if (node.getEntryType() == DCMEntry.SERIES) {
			comp.setIcon(ICON_SERIES);
			String inst = ((DCMSeries)node).getModality();
			if (node.getDate() != null)
				comp.setText("<html><b>" + df.format(node.getDate()) + "</b><br>" + inst);
			else
				comp.setText("<html><b>---" + "</b><br>" + inst);
			
		}
		return comp;
	}
	
}
