package lu.tudor.santec.gecamed.esante.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ESanteLogin.java,v $
 * <br>Revision 1.1  2013-09-19 12:24:43  ferring
 * <br>eSante bugs fixed and documents stored in database
 * <br>
 */
@NamedQueries({
	@NamedQuery(name = ESanteLogin.GET_LOGIN_FOR_PHYSICIAN, query = "SELECT OBJECT(o) FROM ESanteLogin o " + 
																	"WHERE physicianId = :physicianId")
})
@Entity
@Table(schema = "esante", name = "login")
public class ESanteLogin extends GECAMedEntityBean
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	public static final String	GET_LOGIN_FOR_PHYSICIAN	= "getESanteLoginForPhysician";
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private Integer	physicianId;
	
	private String	login;
	
	private String	physicianESanteId;
	
	private String	password;
	
	
	
	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */
	
	@Column(name = "physician_id")
	public Integer getPhysicianId ()
	{
		return physicianId;
	}
	
	
	public void setPhysicianId (Integer physicianId)
	{
		this.physicianId = physicianId;
	}
	
	
	@Column(name = "login")
	public String getLogin ()
	{
		return login;
	}
	
	
	public void setLogin (String login)
	{
		this.login = login;
	}
	

	@Column(name = "physician_esante_id")
	public String getPhysicianESanteId ()
	{
		return physicianESanteId;
	}
	
	
	public void setPhysicianESanteId (String physicianESanteId)
	{
		this.physicianESanteId = physicianESanteId;
	}
	

	@Column(name = "password")
	public String getPassword ()
	{
		return password;
	}
	
	
	public void setPassword (String password)
	{
		this.password = password;
	}
}
