package lu.tudor.santec.gecamed.esante.gui;

import java.awt.Component;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.esante.utils.InfoString;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ESantePatientListRenderer.java,v $
 * <br>Revision 1.7  2014-01-23 15:00:53  ferring
 * <br>Tool tip on patient search list removed
 * <br>
 * <br>Revision 1.6  2013-11-21 10:57:43  ferring
 * <br>alignment of SSN changed to right
 * <br>
 * <br>Revision 1.5  2013-11-21 09:44:52  ferring
 * <br>auto resizing of patient search list
 * <br>
 * <br>Revision 1.4  2013-10-21 08:16:10  ferring
 * <br>patient search rendering fixed
 * <br>
 * <br>Revision 1.3  2013-07-03 13:06:41  ferring
 * <br>eSante module handling changed
 * <br>
 * <br>Revision 1.2  2013-06-24 12:56:33  ferring
 * <br>eSante icon renderer adapts now column width
 * <br>
 * <br>Revision 1.1  2013-06-10 08:22:14  ferring
 * <br>eSante POC
 * <br>
 */

public class ESantePatientListRenderer extends LineColorCellRenderer
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= -8880050750125308166L;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public ESantePatientListRenderer (int alpha, Font font, boolean centerText)
	{
		super(alpha, font, centerText);
		setHorizontalAlignment(SwingConstants.RIGHT);
		setHorizontalTextPosition(SwingConstants.RIGHT);
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	@Override
	public Component getTableCellRendererComponent (JTable table, Object value, 
			boolean isSelected, boolean hasFocus, int row, int column)
	{
		String text = String.valueOf(value != null ? value : "");
		JLabel cell = (JLabel) super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
		
		if (!ESanteGuiUtils.isESanteModuleActivated())
			return cell;
		
//		cell.setToolTipText(cell.getText());
		
		if (value instanceof InfoString && ((InfoString) value).isESantePatient())
		{
			cell.setIcon(ESanteGuiUtils.getESanteIcon(48));
		}
		else
		{
			cell.setIcon(null);
		}
		
		int prefHeight = cell.getPreferredSize().height;
		int realHeight = table.getRowHeight(row);
		if (realHeight < prefHeight && prefHeight > 0) 
			table.setRowHeight(row, prefHeight);
		
		return cell;
	}
}
