package lu.tudor.santec.gecamed.esante.gui.data;


/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: Attachment.java,v $
 * <br>Revision 1.3  2013-10-08 08:57:36  ferring
 * <br>commit comments utf8 correction
 * <br>
 * <br>Revision 1.2  2013-09-30 11:44:09  donak
 * <br>eSanté upload integration
 * <br>
 * <br>Revision 1.1  2013-06-10 08:21:59  ferring
 * <br>eSante POC
 * <br>
 */

public class Attachment
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	public static final String	ENCODING_BINARY	= "binary";
	public static final String	ENCODING_8BIT	= "8bit";
	
	public static final String	CONTENT_TYPE_JPEG	= "image/jpeg";
	public static final String	CONTENT_TYPE_TEXT	= "text/plain";
	public static final String	CONTENT_TYPE_PDF	= "application/pdf";
	public static final String	CONTENT_TYPE_TIFF	= "image/tiff";
	public static final String  CONTENT_TYPE_XML    = "text/xml";
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private String	contentId;
	
	private String	contentType;
	
	private String	transferEncoding;
	
	private String	data;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public Attachment () {}
	
	
	public Attachment (String contentId, String contentType, String transferEncoding, String data)
	{
		super();
		this.contentId = contentId;
		this.contentType = contentType;
		this.transferEncoding = transferEncoding;
		this.data = data;
	}
	
	
	
	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */
	
	public String getContentId ()
	{
		return contentId;
	}
	
	
	public void setContentId (String contentId)
	{
		this.contentId = contentId;
	}
	
	
	public String getContentType ()
	{
		return contentType;
	}
	
	
	public void setContentType (String contentType)
	{
		this.contentType = contentType;
	}
	
	
	public String getTransferEncoding ()
	{
		return transferEncoding;
	}
	
	
	public void setTransferEncoding (String transferEncoding)
	{
		this.transferEncoding = transferEncoding;
	}
	
	
	public String getData ()
	{
		return data;
	}
	
	
	public void setData (String data)
	{
		this.data = data;
	}
	
	
//	public String getB64Data ()
//	{
//		return Security.encodeBase64(data);
//	}
}
