package lu.tudor.santec.gecamed.esante.gui.dialogs;

import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ConnectingDialog.java,v $
 * <br>Revision 1.9  2014-01-17 11:13:33  ferring
 * <br>Progress dialog added, telling that something is in going on, when checking LuxTrust stuff
 * <br>
 * <br>Revision 1.8  2014-01-10 08:26:20  ferring
 * <br>tranlsations added
 * <br>
 * <br>Revision 1.7  2013-11-28 16:38:10  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2013-11-27 07:57:49  ferring
 * <br>No Exception thrown, when connection is canceled by user
 * <br>
 * <br>Revision 1.5  2013-09-30 10:56:31  ferring
 * <br>eSante integration in GECAMed and synchronise funktion added
 * <br>
 * <br>Revision 1.4  2013-09-19 12:24:43  ferring
 * <br>eSante bugs fixed and documents stored in database
 * <br>
 * <br>Revision 1.3  2013-09-10 06:16:28  ferring
 * <br>eSante improvements
 * <br>
 * <br>Revision 1.2  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.1  2013-06-10 08:21:53  ferring
 * <br>eSante POC
 * <br>
 */

public class ConnectingDialog extends ESanteDialog
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= -3102636606841118253L;
	
	private static final String	CONNECTING_TITLE	= "esante.ConnectingDialog.title";
	
	private static final String	CONNECTING_MESSAGE	= "esante.ConnectingDialog.message";
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static ConnectingDialog	instance;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public ConnectingDialog ()
	{
		this(CONNECTING_TITLE, CONNECTING_MESSAGE);
	}
	
	
	public ConnectingDialog (String titleTranslationKey, String messageTranslationKey)
	{
		super(MainFrame.getInstance(),
				Translatrix.getTranslationString(titleTranslationKey),
				OK_CANCEL_BUTTON_MODE);
		
		okButton.getParent().remove(okButton);
		setResizingOptions(RESIZING_NONE);
		
		((JPanel) getContentPane()).getActionMap().put("ok", cancelAction);
		
		JLabel messageLabel = new JLabel(Translatrix.getTranslationString(messageTranslationKey));
		CellConstraints cc = new CellConstraints();
		mainPanel.setLayout(new FormLayout("15px, 40px, 5px, f:p, 25px", "15px, f:p, 15px"));
		mainPanel.add(new JLabel(ESanteGuiUtils.getLoadingImage()), cc.xy(2, 2));
		mainPanel.add(messageLabel, cc.xy(4, 2));
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public void connetionEstablished ()
	{
		okActionCalled();
	}
	
	
	@Override
	public int showCenteredDialog ()
	{
		pack();
		return super.showCenteredDialog();
	}
	
	
	public static ConnectingDialog getInstance ()
	{
		if (instance == null)
			instance	= new ConnectingDialog();
		
		return instance;
	}
	
	private static ConnectingDialog importDialogInstance;
	public static ConnectingDialog getImportCdaDialog ()
	{
		if (importDialogInstance == null)
			// TODO translate
			importDialogInstance	= new ConnectingDialog(
					Translatrix.getTranslationString("esante.ConnectingDialog.importTitle"), 
					Translatrix.getTranslationString("esante.ConnectingDialog.importMessage"));
		
		return importDialogInstance;
	}
}
