package lu.tudor.santec.gecamed.esante.gui.dialogs;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.ESanteProperty;
import lu.tudor.santec.gecamed.esante.ejb.session.beans.ESanteConfigManagerBean;
import lu.tudor.santec.gecamed.esante.ejb.session.interfaces.ESanteConfigManager;
import lu.tudor.santec.gecamed.esante.gui.IconNames;
import lu.tudor.santec.gecamed.esante.gui.luxtrust.UserInactivityMonitor;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.esante.utils.exceptions.SendingStoppedException;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * This is an error dialog that displays a message and a link to a website
 * 
 * @author donak
 * 
 */
public class DocumentNotSupportedPopup extends GECAMedBaseDialogImpl {

	/* ======================================== */
	/*
	 * CONSTANTS /* ========================================
	 */

	private static final long serialVersionUID = 5603949255110390825L;
	// private static Logger logger = Logger.getLogger(ErrorWithLinkPopup.class.getName());

	private static DocumentNotSupportedPopup dialog = new DocumentNotSupportedPopup();
	private CellConstraints cc = new CellConstraints();
	private JLabel descriptionLabel = null;
	private JLabel linkLabel = null;
	private String linkText = null;
	private String url = null;
	private String linkText2 = null;
	private String url2 = null;

	private JLabel descriptionLabel2;

	private JLabel linkLabel2;


	/**
	 * Creates a dialog that asks the user to enter a parameter that will be stored in the database.
	 */
	public DocumentNotSupportedPopup() {

		super(MainFrame.getInstance(), null, CLOSE_BUTTON_MODE);
		this.setTitle(Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.title"));

		setResizingOptions(RESIZING_NONE);

		mainPanel.setLayout(new FormLayout(
				// column definition
				"15px, f:p, 15px, f:p, 10px, f:150px:g, 15px",
				// row definition
				"15px,f:p," + // icon + description
				"15px,f:p," + // link
				"15px,f:p," + // description2
				"15px,f:p," + // link2
				"15px:g"));

		// create the eSanté icon
		JLabel iconLabel = new JLabel(ESanteGuiUtils.getIcon(IconNames.ESANTE_LOGO_SQUARE, ESanteGuiUtils.LARGEPIX));
		iconLabel.setOpaque(false);

		// add the label with the description
		descriptionLabel = new JLabel();
		descriptionLabel.setOpaque(false);
		descriptionLabel.setHorizontalAlignment(JLabel.CENTER);
		descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(Font.BOLD, 12));

		// create the link that allows the user to access further information
		linkText = Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.link.text");
		url = Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.link.url");
		linkLabel = createLinkLabel(linkText, url);
		linkLabel.setText("<HTML><FONT color=\"#000099\">" + linkText + "</FONT></HTML>");
		
		// add the label with the description
		descriptionLabel2 = new JLabel();
		descriptionLabel2.setOpaque(false);
		descriptionLabel2.setHorizontalAlignment(JLabel.CENTER);
		descriptionLabel2.setFont(descriptionLabel2.getFont().deriveFont(Font.BOLD, 12));

		// create the link that allows the user to access further information
		linkText2 = Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.link2.text");
		url2 = Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.link2.url");
		linkLabel2 = createLinkLabel(linkText2, url2);
		linkLabel2.setText("<HTML><FONT color=\"#000099\">" + linkText2 + "</FONT></HTML>");

		// add the components to the dialog
		this.mainPanel.add(iconLabel, cc.xywh(2, 2, 1, 4, CellConstraints.CENTER, CellConstraints.TOP));
		this.mainPanel.add(descriptionLabel, cc.xyw(4, 2, 3, CellConstraints.LEFT, CellConstraints.CENTER));
		this.mainPanel.add(linkLabel, cc.xyw(4, 4, 3, CellConstraints.LEFT, CellConstraints.CENTER));
		this.mainPanel.add(descriptionLabel2, cc.xyw(4, 6, 1, CellConstraints.LEFT, CellConstraints.CENTER));
		this.mainPanel.add(linkLabel2, cc.xyw(6, 6, 1, CellConstraints.LEFT, CellConstraints.CENTER));
	}

	public static DocumentNotSupportedPopup getInstance() {
		return dialog;
	}

	/**
	 * Shows the error poupup
	 * 
	 * @param array of String variables to be used in the descrition translatrix texts
	 * 
	 */
	public void show(String[] params) {

		descriptionLabel.setText(Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.description", params));
		descriptionLabel2.setText(Translatrix.getTranslationString("esante.DisplayDocument.errorPopup.description2", params));
		
		// show the dialog
		pack();
		centerWindowOnOwner();
		setVisible(true);
	}

	/**
	 * Creates a label that represents a link, which opens an URL in the system browser when clicked.
	 * 
	 * @return A label that is able to hold a clickable link
	 */
	private JLabel createLinkLabel(final String text, final String url) {

		final JLabel link = new JLabel();

		// currently no tool tip is needed
		// if(!toolTip.equals("")) link.setToolTipText(toolTip);
		link.setCursor(new Cursor(Cursor.HAND_CURSOR));
		link.addMouseListener(new MouseAdapter() {
			public void mouseExited(MouseEvent arg0) {
				// reset link to normal when mouse leaves
				link.setText("<HTML><FONT color=\"#000099\">" + text + "</FONT></HTML>");
			}

			public void mouseEntered(MouseEvent arg0) {
				// underline link when mouse enters
				link.setText("<HTML><FONT color=\"#000099\"><U>" + text + "</U></FONT></HTML>");
			}
			// fire up the browser and display the link
			public void mouseClicked(MouseEvent arg0) {
				if (Desktop.isDesktopSupported()) {
					try {
						Desktop.getDesktop().browse(new URI(url));
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else {
					// Occurs if system does not support desktop api
					JOptionPane pane = new JOptionPane("Could not open link.");
					JDialog dialog = pane.createDialog(new JFrame(), "");
					dialog.setVisible(true);
				}
			}
		});
		return link;
	}

}