package lu.tudor.santec.gecamed.esante.gui.dialogs;

import javax.swing.JComboBox;

/**
 * 
 * @author donak
 * 
 * @version <br>
 *          $Log: MetaDataComboBox.java,v $
 *          Revision 1.2  2013-10-08 08:57:36  ferring
 *          commit comments utf8 correction
 *
 *          Revision 1.1  2013-10-04 17:22:43  donak
 *          eSanté upload dialog and integration of selected values
 *
 */
public class MetaDataComboBox extends JComboBox {

	
	private static final long	serialVersionUID	= 5603949255110334597L;
	
	private String category = null;

	/**
	 * Creates a ComboBox object that is identical with the standar JComboBox
	 * besides it is able to remember a CDA code category that will be used to
	 * populate the cb
	 * 
	 * @param category
	 *            Name of the CDA code category in the GECAMed db
	 */
	public MetaDataComboBox(String category) {
		super();
		this.category = category;
	}

	/**
	 * Provides the CDA code category that will be used to populate the ComboBox
	 * 
	 * @return CDA code category
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * Set the CDA code category that will be used to populate the ComboBox
	 * 
	 * @param category
	 *            Name of the CDA code category in the GECAMed db
	 */
	public void setCategory(String category) {
		this.category = category;
	}
}
