package lu.tudor.santec.gecamed.esante.gui.tab;

import java.util.ArrayList;
import java.util.Collection;

import lu.tudor.santec.gecamed.esante.ejb.entity.beans.CdaDocument;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: CdaChangeEvent.java,v $
 * <br>Revision 1.3  2014-02-04 10:08:35  ferring
 * <br>eSante ID management completed
 * <br>Only those documents will be shown, that are retrieved by the RSQ
 * <br>
 * <br>Revision 1.2  2013-11-25 08:27:35  ferring
 * <br>Root expanding and notifying of JTree fixed
 * <br>
 * <br>Revision 1.1  2013-11-22 14:51:11  ferring
 * <br>Restructured CDA tree and list notification, in order not to use an EntityBean as model.
 * <br>Buttons added to delete the CDA file and remove the incident entry
 * <br>
 */

public class CdaChangeEvent
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
//	public static final int	DOCUMENTS_CLEARED			= -2;
	public static final int	DOCUMENTS_REMOVED			= -1;
	public static final int	DOCUMENTS_CHANGED			= 0;
	public static final int	DOCUMENTS_ADDED				= 1;
	public static final int DOCUMENTS_SOURCE_CHANGED	= 3;
	
	public static final int MAX_SIZE					= -1;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private Collection<CdaDocument>	documents;
	
	private CdaHandler				source;
	
	private int						eventType;
	
	private int						startIndex;
	
	private int						endIndex;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public CdaChangeEvent (CdaHandler source, Collection<CdaDocument> documents, 
			int eventType, int startIndex, int endIndex)
	{
		init(source, documents, eventType, startIndex, endIndex);
	}
	
	
	public CdaChangeEvent (CdaHandler source, CdaDocument document, 
			int eventType, int startIndex, int endIndex)
	{
		Collection<CdaDocument> documents = new ArrayList<CdaDocument>(1);
		documents.add(document);
		
		init(source, documents, eventType, startIndex, endIndex);
	}
	
	
	public void init (CdaHandler source, Collection<CdaDocument> documents, 
			int eventType, int startIndex, int endIndex)
	{
		this.source		= source;
		this.documents	= documents;
		this.eventType	= eventType;
		this.startIndex	= startIndex;
		this.endIndex	= endIndex;
	}
	
	
	
	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */
	
	public Collection<CdaDocument> getDocuments ()
	{
		return documents;
	}
	
	
	public CdaHandler getSource ()
	{
		return source;
	}
	
	
	public int getEventType ()
	{
		return eventType;
	}
	
	
	public int getStartIndex ()
	{
		return startIndex;
	}
	
	
	public int getEndIndex ()
	{
		return endIndex;
	}
}
