package lu.tudor.santec.gecamed.esante.gui.tab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import lu.tudor.santec.gecamed.esante.ejb.entity.beans.CdaDocument;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: CdaHandler.java,v $
 * <br>Revision 1.9  2014-02-06 14:27:18  ferring
 * <br>check on length added
 * <br>
 * <br>Revision 1.8  2014-02-04 10:08:32  ferring
 * <br>eSante ID management completed
 * <br>Only those documents will be shown, that are retrieved by the RSQ
 * <br>
 * <br>Revision 1.7  2013-12-17 16:49:51  ferring
 * <br>RSQ handling changed
 * <br>
 * <br>Revision 1.6  2013-12-10 11:56:01  ferring
 * <br>load locally cached CDA files when loading DSP
 * <br>
 * <br>Revision 1.5  2013-11-27 07:16:00  ferring
 * <br>Raise condition, where CDA list wasn't updated when opening new patient (hopefully) erased.
 * <br>
 * <br>Revision 1.4  2013-11-26 10:54:19  ferring
 * <br>clear documents before notifying about remove
 * <br>
 * <br>Revision 1.3  2013-11-26 08:15:25  ferring
 * <br>notification fixed
 * <br>
 * <br>Revision 1.2  2013-11-25 08:27:37  ferring
 * <br>Root expanding and notifying of JTree fixed
 * <br>
 * <br>Revision 1.1  2013-11-22 14:51:11  ferring
 * <br>Restructured CDA tree and list notification, in order not to use an EntityBean as model.
 * <br>Buttons added to delete the CDA file and remove the incident entry
 * <br>
 */

public class CdaHandler
{
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
//	private static Logger logger = Logger.getLogger(CdaHandler.class.getName());
	
	
	private List<CdaDocument>	documents	= new ArrayList<CdaDocument>();
	
	private Dsp					linkedDsp;
	
	private Set<CdaListener>	listeners	= new HashSet<CdaListener>();
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public void setDsp (Dsp dsp)
	{
		notifyListener(new CdaChangeEvent(this, documents, CdaChangeEvent.DOCUMENTS_REMOVED, 0, CdaChangeEvent.MAX_SIZE));
		
		linkedDsp	= dsp;
		documents.clear();
		if (linkedDsp != null)
			documents.addAll(linkedDsp.getDocuments());
		
		notifyListener(new CdaChangeEvent(this, documents, CdaChangeEvent.DOCUMENTS_ADDED, 0, CdaChangeEvent.MAX_SIZE));
	}
	
	
	public int getDocumentCount ()
	{
		if (linkedDsp == null)
			return 0;
		
		return linkedDsp.getDocuments().size();
	}
	
	
	public CdaDocument getDocument (int index)
	{
		if (linkedDsp == null 
				|| index < 0 
				|| index >= linkedDsp.getDocuments().size())
			return null;
		
		return linkedDsp.getDocuments().get(index);
	}
	
	
	public int indexOf (CdaDocument document)
	{
		if (linkedDsp == null)
			return -1;
		
		return linkedDsp.getDocuments().indexOf(document);
	}
	
	
	public void addCdaListener (CdaListener l)
	{
		listeners.add(l);
	}
	
	
	public void fireDocumentChanged (CdaDocument document)
	{
		int index = indexOf(document);
		CdaChangeEvent e = new CdaChangeEvent(this, document, CdaChangeEvent.DOCUMENTS_CHANGED, index, index);
		notifyListener(e);
	}
	
	
	public Integer getPatientId ()
	{
		return linkedDsp.getPatientId();
	}
	
	
	public Integer getDspId ()
	{
		return linkedDsp.getId();
	}
	
	
	public Dsp getDsp ()
	{
		return linkedDsp;
	}
	
	
	public CdaDocument getDocumentWithEntryId (Integer entryId)
	{
		if (entryId != null)
		{
			for (CdaDocument document : linkedDsp.getDocuments())
			{
				if (document.getIncidentEntryId() != null 
						&& document.getIncidentEntryId().equals(entryId))
					return document;
			}
		}
		
		return null;
	}
	
	
//	public void markDocumentsAsUnavailable (Set<String> unavailableUids)
//	{
//		String uid;
//		
//		for (CdaDocument doc : linkedDsp.getDocuments())
//		{
//			uid = doc.getDocumentUniqueId();
//			if (unavailableUids.contains(uid))
//				doc.setAvailable(false);
//		}
//	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void notifyListener (CdaChangeEvent e)
	{
		for (CdaListener l : listeners)
			l.documentsChanged(e);
	}
}
