package lu.tudor.santec.gecamed.esante.gui.tab;

import java.awt.EventQueue;
import java.util.LinkedList;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: UpdateWorker.java,v $
 * <br>Revision 1.2  2014-01-23 15:02:33  ferring
 * <br>DSP last names changed
 * <br>
 * <br>Revision 1.1  2013-11-27 07:16:00  ferring
 * <br>Raise condition, where CDA list wasn't updated when opening new patient (hopefully) erased.
 * <br>
 */

public class UpdateWorker extends Thread
{
	private static Thread worker = new UpdateWorker();
	
	private static boolean isEnqueued = false;
	
	private static LinkedList<ESanteTab> updates = new LinkedList<ESanteTab>();
	
	private static ESanteTab currentUpdate;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	private UpdateWorker () {}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public static void updateList (ESanteTab tabToUpdate)
	{
		synchronized (updates)
		{
			if (updates.contains(tabToUpdate) || 
					tabToUpdate == null) 
				return;
			
			updates.push(tabToUpdate);
		}
		
		startWorker();
	}
	
	
	@Override
	public void run ()
	{
		while (!updates.isEmpty())
		{
			currentUpdate	= updates.pop();
			currentUpdate.refreshList();
			currentUpdate	= null;
		}
		isEnqueued = false;
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private static synchronized void startWorker ()
	{
		if (!isEnqueued)
		{
			isEnqueued = true;
			EventQueue.invokeLater(worker);
		}
	}
}
