package lu.tudor.santec.gecamed.esante.gui.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: GifIconLabel.java,v $
 * <br>Revision 1.1  2013-09-30 10:56:41  ferring
 * <br>eSante integration in GECAMed and synchronise funktion added
 * <br>
 */

public class GifIconLabel extends JLabel
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public GifIconLabel (ImageIcon icon)
	{
		super(icon);
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	@Override
	public void setIcon (Icon icon)
	{
		if (icon instanceof ImageIcon)
			super.setIcon(icon);
	}
	
	
	@Override
	protected void paintComponent (Graphics g)
	{
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.drawImage(((ImageIcon) getIcon()).getImage(), 0, 0, getParent());
		g2d.dispose();
	}
}
