package lu.tudor.santec.gecamed.esante.utils.exceptions;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: SendingStoppedException.java,v $
 * <br>Revision 1.4  2014-02-06 14:31:19  ferring
 * <br>SendingStoppedException handling and logging changed
 * <br>
 * <br>Revision 1.3  2013-12-13 12:31:32  ferring
 * <br>Exception handling changed
 * <br>
 * <br>Revision 1.2  2013-12-10 11:59:47  ferring
 * <br>webservice error handling improved
 * <br>
 * <br>Revision 1.1  2013-11-12 15:37:53  ferring
 * <br>downloads can now be stopped
 * <br>
 */

public class SendingStoppedException extends Exception
{
	private static final long	serialVersionUID	= 1L;
	
	private boolean stoppedByUser;
	
	public SendingStoppedException (boolean stoppedByUser)
	{
		super("Sending stopped" + (stoppedByUser ? " by user" : "") + "!");
		this.stoppedByUser = stoppedByUser;
	}
	
	
	public boolean isStoppedByUser ()
	{
		return this.stoppedByUser;
	}
}
