package lu.tudor.santec.gecamed.formeditor.gui;

import java.awt.Component;

import javax.swing.JTable;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntryType;

public class FormIncidentEntryRenderer extends LineColorCellRenderer {

	private static final long serialVersionUID = 1L;
	 
	//public static final String FORM_HISTORY_SHORTCUT = "Fm";
	
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) 
	{
		if (value instanceof IncidentEntry) {
			if (column == 2) 
			{
				return super.getTableCellRendererComponent(table, IncidentEntryType.FORM, isSelected, hasFocus, row, column);
			} 
			else if (column == 3) 
			{
				String text = ((IncidentEntry)value).getTextContent();
				return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
			}
		}
		
		return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
	}
}
