package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.core.gui.widgets.autocompletion.GECAMedAutoCompletionTextComponent;
import lu.tudor.santec.gecamed.formeditor.gui.controller.EditorPanelController;
import lu.tudor.santec.gecamed.formeditor.gui.controller.FormController;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletionTextComponent;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class EditableAutoCompletionTextField extends EditableTextField
{
	private static final long serialVersionUID = 1L;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public EditableAutoCompletionTextField()
	{
		super(new GECAMedAutoCompletionTextComponent(new JTextField(), null));
	}
	
	public EditableAutoCompletionTextField (JComponent component)
	{
		super(component);
	}
	
	
	
	/* ======================================== */
	// 		OVERRIDDEN METHODS
	/* ======================================== */
	
	@Override
	protected void initType()
	{
		super.initType();
		JTextComponent 	text 	= getTextComponent();
		TransferHandler handler = new TransferHandler("name");
		
		text.setName(this.getName());
		text.setTransferHandler(handler);
		text.setDropTarget(null);
		text.addMouseListener(new EditorPanelController(model));
	}
	
	
	@Override
	public String getStructure()
	{
		return getACComponent().getProvider().getContext();
	}
	
	@Override
	public void setStructure(String text)
	{
		String context = getStructure();
		if (context == null || !context.equals(text))
			getACComponent().changeProvider(text);
	}
	
	
	@Override
	public JComponent copyComponent(FormModel model)
	{
		AutoCompletionTextComponent actc = (AutoCompletionTextComponent) this.component;
		
		FormController  controller 	= new FormController(model);
		if (getScriptAt(CARET_UPDATED).length() > 0)
		{
			actc.getTextComponent().addCaretListener(controller);
			controller.setCodeAt(FormController.CARET_UPDATED, getScriptAt(CARET_UPDATED));
		}
		addDefaultListener(actc.getTextComponent(), controller);
		return actc;
	}
	
	
	@Override
	public String getComponentType () 
	{
		return "acTextfield";
	}
	
	
	@Override
	public String getTypeTranslation () 
	{
		return Translatrix.getTranslationString("formeditor.add_ac_textfield");
	}
	
	
	@Override
	protected JTextComponent getTextComponent()
	{
		return ((GECAMedAutoCompletionTextComponent)component).getTextComponent();
	}
	
	
	@Override
	public DefaultOptionPanel createOptionPanel()
	{
		CellConstraints 	cc 			= new CellConstraints();
		DefaultOptionPanel 	propPanel 	= super.createOptionPanel();
		
		/* **************************************** */
		// 		COMPONENT TO ENTER CONTEXT
		/* **************************************** */
		
		String 				context 	 = getACComponent().getProvider().getContext();
		JTextField 			contextField = new JTextField(context == null ? "" : context);
		contextField.addFocusListener(new FocusListener()
		{
			public void focusGained(FocusEvent e) {}

			public void focusLost(FocusEvent e)
			{
				JTextField 				contextField 	= (JTextField) e.getSource();
				String 					context 		= contextField.getText();
				
				getACComponent().changeProvider(context);
			}
		});
		
		propPanel.appendRow(new NamedComponent(
				Translatrix.getTranslationString("context"), 
				contextField));
		
		/* **************************************** */
		// 		BUTTONS TO ADD / REMOVE / EDIT
		/* **************************************** */
		
		JButton 			addButton 	= new JButton(GECAMedModule.getSmallIcon(GECAMedIconNames.ADD));
		addButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				getACComponent().getHandler().showSaveCompletionDialog();
			}
		});
		
		JButton 			editButton 	= new JButton(GECAMedModule.getSmallIcon(GECAMedIconNames.EDIT));
		editButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				getACComponent().getHandler().showEditCompletionDialog();
			}
		});
		
		JPanel 				buttonPanel = new JPanel(new FormLayout(
				"f:p:g, 5px, f:p:g, 5px, f:p:g", "f:p"));
		buttonPanel.setOpaque(false);
		buttonPanel.add(addButton,		cc.xy(1, 1));
//		buttonPanel.add(removeButton, 	cc.xy(3, 1));
		buttonPanel.add(editButton, 	cc.xy(5, 1));
		
		propPanel.appendRow(buttonPanel);
		
		return propPanel;
	}
	
	
	@Override
	protected void addDefaultListener(JComponent component,
			FormController controller)
	{
		// initializes the listener, you can add to an JComponent
		if (component instanceof GECAMedAutoCompletionTextComponent)
			component = ((GECAMedAutoCompletionTextComponent) component).getTextComponent();
		
		super.addDefaultListener(component, controller);
	}
	
	
	@Override
	public void setName(String name)
	{
		super.setName(name);
		getTextComponent().setName(name);
	}
	
	@Override
	public void copyLayout(JComponent newComponent, JPanel componentPanel)
	{
		super.copyLayout(((AutoCompletionTextComponent)newComponent).getTextComponent(), componentPanel);
		
	} 
	
	
	@Override
	public void dispose()
	{
		getACComponent().uninstallAutoCompletion();
		super.dispose();
	}
	
	
	/* ---------------------------------------- */
	// 		BACKGROUND PAINTING
	/* ---------------------------------------- */
	
	@Override
	public JComponent getComponentForProperty()
	{
		return getTextComponent();
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	protected GECAMedAutoCompletionTextComponent getACComponent ()
	{
		return (GECAMedAutoCompletionTextComponent) component;
	}
}
