package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ColorUIResource;

import lu.tudor.santec.gecamed.formeditor.gui.controller.FormController;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;

import com.jgoodies.forms.layout.CellConstraints;


public class EditableButton extends EditableComponent {
	/**
	 * @author Jens Ferring
	 * 
	 * This represents a JButton as EditableComponent.
	 */
	private static final long serialVersionUID = 1L;
	
	private static final Color BUTTON_COLOR = new ColorUIResource(238, 238, 238);
	
	public static final int LISTENER_METHOD_SIZE = 1;
	public static final int ACTION_PERFORMED = SUPER_LISTENER_METHOD_SIZE;
	
	public EditableButton () {
		super();
		component = new JButton(); 
//		{
//			private static final long serialVersionUID = 1L;
//
//			protected void paintComponent(java.awt.Graphics g) {
//				paintImage(g, getHorizontalAlignment(), getVerticalAlignment());
//				super.paintComponent(g);
//			};
//		};
//		super.setForegroundAlpha(255);
	}
	
	@Override
	public void init (CellConstraints constraints, FormEditorModel model, byte formModelType) {
		super.init(constraints, model, formModelType);
//		component.setBackground(Color.blue);
		getPropertyPanel().setBackgroundColor(component.getBackground());
		
		iconEnabled = true;
	}
	
	@Override
	public void setSelected (boolean value) {
		selected = value;
	}

	@Override
	public String getText() {
		/* ======================================== */
		return ((JButton)component).getText();
		/* ======================================== */
	}

	@Override
	public void setText (String text) {
		/* ======================================== */
		((JButton)component).setText(text);
		/* ======================================== */
	}

	@Override
	public String getStructure() {
		/* ======================================== */
		// create and fill the properties
		Properties structure = new Properties(); 
		writeImage(structure);
		
		// return the properties String
		StringWriter writer = new StringWriter();
		try {
			structure.store(writer, "");
		} catch (IOException e) {
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		return writer.toString();
		/* ======================================== */
	}

	@Override
	public void setStructure(String text) {
		/* ======================================== */
		// create and fill the properties 
		StringReader reader = new StringReader(text);
		Properties structure = new Properties();
		try {
			structure.load(reader);
		} catch (IOException e) {
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		
		// create and scale the image
		readImage(structure);
		/* ======================================== */
	}
	
	@Override
	public void setIcon (Icon newIcon) 
	{
		((JButton)component).setIcon(newIcon);
	}
	
	@Override
	public Icon getIcon () 
	{
		return ((JButton)component).getIcon();
	}

	@Override
	public String getComponentType () {
		/* ======================================== */
		return "button";
		/* ======================================== */
	}
	
	@Override
	public JButton copyComponent (FormModel model) 
	{
		JButton b = (JButton) this.component;
		
		FormController controller = new FormController(model);
		if (getScriptAt(ACTION_PERFORMED).length() > 0)
		{
			b.addActionListener((ActionListener)controller);
			controller.setCodeAt(FormController.ACTION_PERFORMED, getScriptAt(ACTION_PERFORMED));
		}
		addDefaultListener(b, controller);
		
		return b;
	}

	@Override
	public int getListenerMethodSize() {
		return LISTENER_METHOD_SIZE;
	}

	@Override
	protected void addListenerMethodNames() {
		listenerMethodNames[ACTION_PERFORMED] = "actionPerformed";
	}
	
	@Override
	public String getTypeTranslation () {
		/* ======================================== */
		return Translatrix.getTranslationString("formeditor.add_button");
		/* ======================================== */
	}
	
	@Override
	public DefaultPropertyPanel createPropertiesPanel () {
		/* ======================================== */
		DefaultPropertyPanel panel = super.createPropertiesPanel();
//		c.remove(this.backgroundColorButton);
		panel.getBackgroundColorComponent().setVisible(false);
		return panel;
		/* ======================================== */
	}
	
	@Override
	public void resetComponentBackground () {
		super.resetComponentBackground();
		if (getImage() == null) {
			this.component.setBackground(BUTTON_COLOR);
		}
//		this.component.setOpaque(true);
		this.validate();
	}
	
	@Override
	public void setComponentBackground (Color c) {
		super.setComponentBackground(c);
		if (getImage() != null)
			return;
		
		if (component.isOpaque())
			this.component.setBackground(BUTTON_COLOR);
		else
			this.component.setBackground(Color.LIGHT_GRAY);
	}
	
	@Override
	public void setComponentOpaq (boolean opaque) {
		super.setComponentOpaq(opaque);
		component.setOpaque(opaque);
		if (getImage() != null)
			return;
		
		if (opaque) {
			component.setBackground(BUTTON_COLOR);
		} else {
			component.setBackground(Color.LIGHT_GRAY);
		}
	}
	
	
//	public static void main(String[] args) {
//		/* ======================================== */
//		JFrame frame = new JFrame("TEST");
//		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//		frame.setLayout(new BorderLayout());
//		
//		JButton b = new JButton();
//		b.setAction(new AbstractAction("TEST BUTTON") {
//			public void actionPerformed(ActionEvent e) {
//				/* ---------------------------------------- */
//				JButton b = (JButton) e.getSource();
//				if (b.getBackground() instanceof ColorUIResource) {
//					b.setBackground(Color.RED);
//				} else {
//					ColorUIResource c = new ColorUIResource(0);
//					b.setBackground(c);
//				}
//				/* ---------------------------------------- */
//			}
//		});
//		
//		frame.add(b, BorderLayout.CENTER);
//		
//		frame.pack();
//		frame.setVisible(true);
//		/* ======================================== */
//	}
}
