package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;

public class EditableCellRenderer extends DefaultTableCellRenderer
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	public static final Color ODD_LINE_COLOR 		= GECAMedColors.c_OddLineBackground;
	public static final Color EVEN_LINE_COLOR 		= GECAMedColors.c_EvenLineBackground;
	public static final Color SELECTED_LINE_COLOR 	= GECAMedColors.c_TabSelection;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private ArrayList<Color> 			lineColors;
	
	private Color 						selectionColor;
	
	private boolean 					adaptRowHeight;
	
	private HashMap<Integer, Integer> 	columnAlignments;

	private HashMap<Integer, Integer> 	rowAlignments;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public EditableCellRenderer ()
	{
		lineColors 		= new ArrayList<Color>(2);
		selectionColor 	= SELECTED_LINE_COLOR;
		adaptRowHeight 	= true;
		columnAlignments= new HashMap<Integer, Integer>();
		rowAlignments 	= new HashMap<Integer, Integer>();
		
		lineColors.add(ODD_LINE_COLOR);
		lineColors.add(EVEN_LINE_COLOR);
		
		this.setOpaque(true);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
	{
		Color 	bgColor;
		Integer alignment;
		
		
		// set the value as text
		setText(value != null ? value.toString() : "");
		
		
		// set row color
		if (isSelected)
			 bgColor = selectionColor;
		else bgColor = lineColors.get(row % lineColors.size());
		
		if (bgColor != null)
			this.setBackground(bgColor);
		
		
		// set the row height
		setSize(table.getColumnModel().getColumn(column).getWidth(),
				getPreferredSize().height);
		
		if (adaptRowHeight && table.getRowHeight(row) < getPreferredSize().height) 
			table.setRowHeight(row, getPreferredSize().height);
		
		
		// set the alignment
		alignment 	= columnAlignments.get(new Integer(column));
		if (alignment != null)
			this.setHorizontalAlignment(alignment);

		alignment 	= rowAlignments.get(Integer.valueOf(row));
		if (alignment != null)
			this.setVerticalAlignment(alignment);
		
		return this;
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public ArrayList<Color> getLineColors()
	{
		return lineColors;
	}
	
	
	public void setLineColors(ArrayList<Color> lineColors)
	{
		this.lineColors = lineColors;
	}
	
	
	public Color getSelectionColor()
	{
		return selectionColor;
	}
	
	
	public void setSelectionColor(Color selectionColor)
	{
		this.selectionColor = selectionColor;
	}
	
	
	public boolean isAdaptRowHeight()
	{
		return adaptRowHeight;
	}
	
	
	public void setAdaptRowHeight(boolean adaptRowHeight)
	{
		this.adaptRowHeight = adaptRowHeight;
	}
	
	
	public HashMap<Integer, Integer> getColumnAlignments()
	{
		return columnAlignments;
	}
	
	
	public void setColumnAlignments(HashMap<Integer, Integer> alignments)
	{
		this.columnAlignments = alignments;
	}
	
	
	public void setColumnAlignment (int column, int alignment)
	{
		this.columnAlignments.put(Integer.valueOf(column), Integer.valueOf(alignment));
	}
	
	
	public HashMap<Integer, Integer> getRowAlignments()
	{
		return rowAlignments;
	}
	
	
	public void setRowAlignments(HashMap<Integer, Integer> alignments)
	{
		this.rowAlignments = alignments;
	}
	
	
	public void setRowAlignment (int row, int alignment)
	{
		this.rowAlignments.put(Integer.valueOf(row), Integer.valueOf(alignment));
	}
}
