package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.formeditor.gui.controller.AbstractListener;
import lu.tudor.santec.gecamed.formeditor.gui.controller.FormController;
import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
import lu.tudor.santec.gecamed.formeditor.gui.model.DatabaseReferences;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.jdom.Element;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;


public class EditableDataTable extends EditableComponent {
	
	private static final long serialVersionUID = 1L;
	
//	public static final String COLUMN_NAME_PREFIX = "column.name.";
	public static final String COLUMN_REFERENCE_PREFIX = "column.ref.";
	
	
//	private EditableDataTableModel tableModel;
	
	/**
	 * Contains the references to the components (name of the components)
	 */
//	private Vector<ComboBoxElement<String>> references;
	
	/**
	 * Contains to every reference a name that is shown as column name.
	 * If there is no entry for a reference, the column name will be the 
	 * reference name.
	 */
//	private HashMap<String, String> refToName;
	
	
	private DatabaseReferences database;
	
	private JList columnRefList;

	private LinkedList<ReloadListener> reloadListeners = new LinkedList<ReloadListener>();

//	protected JScrollPane scrollPane;
	
	
	public EditableDataTable () {
		/* ======================================== */
		super();
//		this.tableModel = new EditableDataTableModel();
		super.component = new JTable(new EditableDataTableModel())
		{
			private static final long	serialVersionUID	= 1L;

			@SuppressWarnings("unused")
			public TableCellRenderer getDefaultRenderer()
			{
				return super.getDefaultRenderer(String.class);
			}
		};
		
//		references = new Vector<ComboBoxElement<String>>();
		/* ======================================== */
	}

	@Override
	public void init (CellConstraints constraints, FormEditorModel model, byte formModelType) {
		/* ======================================== */
		super.init(constraints, model, formModelType);
		this.remove(component);
		JScrollPane scrollPane = new JScrollPane(component);
		scrollPane.getVerticalScrollBar().setUnitIncrement(16);
		scrollPane.setOpaque(false);
		scrollPane.getViewport().setOpaque(false);
		scrollPane.setBorder(BorderFactory.createEmptyBorder());
		this.add(scrollPane, BorderLayout.CENTER);
		
		((JTable)component).setDefaultRenderer(String.class, new EditableCellRenderer());
		/* ======================================== */
	}
	
	
	@Override
	protected void addListenerMethodNames() {
		listenerMethodNames[SUPER_LISTENER_METHOD_SIZE] = "contentReload";
	}
	
	
	@Override
	public JComponent copyComponent(FormModel model) 
	{
		JTable table = this.getTable();
		
		this.setDatabaseReference(model.getDBReferences());
		
		String structure = this.getStructure();
		JComponent tmp = component;
		this.setComponent(table);
		this.setStructure(structure);
		this.fillTable(model.getFormTab() != null);
		this.setComponent(tmp);
		
		// ADD DEFAULT LISTENER (to react on the script)
		FormController controller = new FormController(model);
		if (getScriptAt(SUPER_LISTENER_METHOD_SIZE).length() > 0)
		{
			controller.setCodeAt(FormController.CONTENT_RELOADED, getScriptAt(SUPER_LISTENER_METHOD_SIZE));
			this.addReloadListener(controller);
		}
		addDefaultListener(table, controller);
		
		this.setDatabaseReference(null);
		
		return table;
	}

	@Override
	public String getComponentType() {
		return "datatable";
	}

	@Override
	protected int getListenerMethodSize() {
		// no listeners to add
		return 1;
	}
	
	@Override
	public String getTypeTranslation() {
		return Translatrix.getTranslationString("formeditor.add_data_table");
	}

	@Override
	public String getStructure() {
		/* ======================================== */
		Properties structure = new Properties();
		Vector<ComboBoxElement<String>> references = getModel().getColumnReferences();
		/* **********  save the references of the columns  ********** */
		for (int index = 0; index < references.size(); index++) {
			/* ---------------------------------------- */
			String reference = references.elementAt(index).getTranslation();
			String colName = references.elementAt(index).getValue();
			structure.setProperty(COLUMN_REFERENCE_PREFIX + index, 
					(reference == null ? "" : reference) + ";" + (colName == null ? "" : colName));
//			structure.setProperty(COLUMN_NAME_PREFIX	  + reference,	colName);
			/* ---------------------------------------- */
		}
		/* **************************************** */
		
		/* **********  save the column width  ********** */
		// TODO getStructure
//		this.columnWidth = new int[table.getColumnCount()];
		String colWidths = "";
		int columnCount = getTable().getColumnCount();
		for (int index = 0; index < columnCount; index++) {
			/* ---------------------------------------- */
			colWidths += getModel().getColumnWidth(index) + ";";
			/* ---------------------------------------- */
		}
		structure.setProperty("column.width", colWidths);
		/* **************************************** */
		
		StringWriter writer = new StringWriter();
		try {
			structure.store(writer, "");
		} catch (IOException e) {
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		return writer.toString();
		/* ======================================== */
	}
	
	@Override
	public void setStructure(String text) {
		/* ======================================== */
		Properties structure = new Properties();
		try {
			structure.load(new StringReader(text));
		} catch (IOException e) {
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		
		/* **********  load the references of the columns  ********** */
		TreeMap<Integer, ComboBoxElement<String>> references = new TreeMap<Integer, ComboBoxElement<String>>();
		Enumeration<?> keys = structure.propertyNames();
		while (keys.hasMoreElements()) {
			/* ---------------------------------------- */
			String key = (String)keys.nextElement();
			String[] value = structure.getProperty(key).split(";");
			
			if (key.startsWith(COLUMN_REFERENCE_PREFIX)) {
				/* ---------------------------------------- */
				try {
					Integer i = Integer.parseInt(key.replaceFirst(COLUMN_REFERENCE_PREFIX, ""));
					references.put(i, new ComboBoxElement<String>(
							(value.length < 1 ? "" : value[0]), 
							(value.length < 2 ? "" : value[1])));
				} catch (NumberFormatException e) {
					continue;
				}
				/* ---------------------------------------- */
			}
			/* ---------------------------------------- */
		}
		getModel().setData(new Vector<Vector<String>>(), 
				new Vector<ComboBoxElement<String>>(references.values()));
		/* **************************************** */
		
		/* **********  load the column size  ********** */
		String colWidths = structure.getProperty("column.width");
		if (colWidths != null && colWidths.length() > 0) {
			String[] colWidthsArray = colWidths.split(";");
			
			TableColumn col;
			int index;
			// change or add the columns to the column model
			Vector<String> columnNames = getModel().getColumnNames();
			
			for (index = 0; index < colWidthsArray.length; index++) {
				/* ---------------------------------------- */
				int width = Integer.parseInt(colWidthsArray[index]);
				
				if (index >= columnNames.size()) {
					continue;
				}
				String identifier = columnNames.get(index);
				
				DefaultTableColumnModel columnModel = getModel().getColumnModel();
				if (index < columnModel.getColumnCount()) {
					col = columnModel.getColumn(index);
					col.setWidth(width);
				} else {
					col = new TableColumn(index, width);
					columnModel.addColumn(col);
				}
				
				col.setIdentifier(identifier);
				col.setHeaderValue(identifier);
//				col.setHeaderRenderer(new DefaultTableCellRenderer());
				
//				this.columnWidth[index] = width;
				if (index < getTable().getColumnCount()) {
					getTable().getColumnModel().getColumn(index).setPreferredWidth(width);
				}
				/* ---------------------------------------- */
			}
			
			// delete the unneeded columns
			DefaultTableColumnModel columnModel = getModel().getColumnModel();
			for (; index < columnModel.getColumnCount(); index++) {
				columnModel.removeColumn(columnModel.getColumn(index));
			}
			
			getTable().setColumnModel(getModel().getColumnModel());
		}
		/* **************************************** */
		/* ======================================== */
	}
	
	/**
	 * Takes the references and loads the data for the references for each 
	 * existing for form of the current patient out of the database.
	 * Afterwards the data is written into the table.
	 */
	public void fillTable(boolean loadData) {
		/* ======================================== */
		Vector<Vector<String>> tableData = null;
		if (loadData && database != null) {
			/* ---------------------------------------- */
			tableData = database.getTableValues(null, null, getModel().getColumnReferences());
			/* ---------------------------------------- */
		}
		
		if (!loadData && (database == null || tableData == null || tableData.isEmpty())) {
			/* ---------------------------------------- */
			tableData = new Vector<Vector<String>>();
			tableData.addElement(new Vector<String>());
			
			if (model != null) {
				/* ---------------------------------------- */
				Map<String, EditableComponent> components = model.getEditableComponents();
				for (ComboBoxElement<String> elem : getModel().getColumnReferences()) {
					EditableComponent ec = components.get(elem.getTranslation());
					
					if (ec != null) {
						tableData.get(0).addElement(ec.getText());
					} else {
						tableData.get(0).addElement("");
					}
				}
				/* ---------------------------------------- */
			}
		}
		
		// set the data and reset the column model, to keep the column size
		this.getTable().setColumnModel(new DefaultTableColumnModel());
		this.getModel().setData(tableData, this.getModel().getColumnReferences());
		this.getTable().setColumnModel(getModel().getColumnModel());
		
		component.validate();
		/* ======================================== */
	}

	@Override
	public String getText() {
		// nothing to do;
		return "";
	}

	@Override
	public void setText(String text) {
		// nothing to do
//		fillTable();
	}
	
	@Override
	public Element getDataAsXML()
	{
		Element data = new Element(getKey());
//		Element text = new Element(XML_ELEMENT_TEXT);
//		
//		text.addContent("");
//		data.addContent(text);
		
		data.addContent(EditableTable.createTableStructure(getTable()));
		
		addDefaultProperties(data);
		return data;
	}
	
	@Override
	public DefaultOptionPanel createOptionPanel () 
	{
		/* ======================================== */
		DefaultOptionPanel optionPanel = super.createOptionPanel();
//		JPanel optionPanel = new JPanel (new FormLayout("f:155px", 
//				"5px, f:100px:g, " + // list
//				"5px, f:p:g, " + // buttons
//				"5px, f:p:g, " + // column name
//				"5px, f:p:g, " + // column reference
//				"5px, 0px"));
//		optionPanel.setOpaque(false);
		CellConstraints cc = new CellConstraints();
//		int row = 0;
		
		
		columnRefList = new JList();
		
		if (getModel().getColumnCount() <= 0) {
			/* ---------------------------------------- */
			getModel().addColumn(new ComboBoxElement<String>(" ", ""));
			/* ---------------------------------------- */
		}
		this.rearrangeList();
		getModel().fireTableStructureChanged();
//		columnRefList.setSelectedIndex(0);
//		component.validate();
		
		columnRefList.setSelectionMode(DefaultListSelectionModel.SINGLE_SELECTION);
		boolean smthSelected = columnRefList.getSelectedIndex() > 0;
		
		optionPanel.appendRow(new NamedComponent(
						Translatrix.getTranslationString("formeditor.column"), 
						new JScrollPane(columnRefList)), 
				new RowSpec(RowSpec.FILL, Sizes.pixel(100), RowSpec.NO_GROW));
		
		ComboBoxElement<?> referenceElem = (ComboBoxElement<?>)columnRefList.getSelectedValue();
		
		
		// BUTTON-PANEL (ADD / REMOVE / UP / DOWN)
		JPanel buttonPanel = new JPanel(new FormLayout(
				"p:g, f:24px, 2px, f:24px, 2px, f:24px, 2px, f:24px",
				"f:24px"));
		buttonPanel.setOpaque(false);
		
		
		// 	-- ADD BUTTON
		JButton addReferenceButton = new JButton("", 
				GECAMedModule.getScaledIcon(GECAMedIconNames.ADD, 20));
		addReferenceButton.addActionListener(new ActionListener() {
			/* ======================================== */
			public void actionPerformed(ActionEvent e) {
				/* ---------------------------------------- */
				ComboBoxElement<String> newElem = new ComboBoxElement<String>(" ", new String[]{null});
				int index = columnRefList.getSelectedIndex();
				if (index < 0 || index >= columnRefList.getComponentCount()-1) {
					getModel().addColumn(newElem);
					rearrangeList(getModel().getColumnCount()-1);
				} else {
					getModel().addColumn(index, newElem);
					rearrangeList(index);
					columnRefList.setSelectedValue(columnRefList.getSelectedValue(), true);
//					columnRefList.setSelectedIndex(index);
				}
				/* ---------------------------------------- */
			}
			/* ======================================== */
		});
		
		
		// 	-- REMOVE BUTTON
		JButton removeReferenceButton = new JButton("", 
				GECAMedModule.getScaledIcon(GECAMedIconNames.REMOVE, 20));
		removeReferenceButton.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent e) {
				/* ---------------------------------------- */
				int index = columnRefList.getSelectedIndex();
				getModel().removeColumn(index);
				rearrangeList();
				/* ---------------------------------------- */
			}
		});
		removeReferenceButton.setEnabled(smthSelected);
		
		
		// 	-- UP BUTTON
		JButton pushReferenceUpButton =  new JButton("", 
				GECAMedModule.getScaledIcon(GECAMedIconNames.UP, 20));
		pushReferenceUpButton.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent e) {
				/* ---------------------------------------- */
				int selectedIndex = columnRefList.getSelectedIndex();
				if (selectedIndex > 0) {
					getModel().switchColumns(selectedIndex, selectedIndex-1);
					rearrangeList(selectedIndex-1);
				}
				/* ---------------------------------------- */
			}
		});
		pushReferenceUpButton.setEnabled(smthSelected);

		
		// 	-- DOWN BUTTON
		JButton pushReferenceDownButton =  new JButton("", 
				GECAMedModule.getScaledIcon(GECAMedIconNames.DOWN, 20));
		pushReferenceDownButton.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent e) {
				/* ---------------------------------------- */
				int selectedIndex = columnRefList.getSelectedIndex();
				if (selectedIndex >= 0 && selectedIndex < getModel().getColumnCount()-1) {
					getModel().switchColumns(selectedIndex, selectedIndex+1);
					rearrangeList(selectedIndex+1);
				}
				/* ---------------------------------------- */
			}
		});
		pushReferenceDownButton.setEnabled(smthSelected);
		
		
		buttonPanel.add(addReferenceButton, cc.xy(2, 1));
		buttonPanel.add(removeReferenceButton, cc.xy(4, 1));
		buttonPanel.add(pushReferenceUpButton, cc.xy(6, 1));
		buttonPanel.add(pushReferenceDownButton, cc.xy(8, 1));
		
		optionPanel.appendRow(buttonPanel);
		
		
		// REFERENCE CHOOSER
		JComboBox referenceChooser = new JComboBox(super.getComponentList(true));
		referenceChooser.setEnabled(smthSelected);
		referenceChooser.addItem(new ComboBoxElement<String>(
				Translatrix.getTranslationString("formeditor.creation_date"), 
				EditableChart.CREATION_DATE_REF));
		referenceChooser.setSelectedItem(referenceElem);
		referenceChooser.addActionListener(new ActionListener() {
			/* ======================================== */
			public void actionPerformed(ActionEvent e) {
				/* ---------------------------------------- */
				ComboBoxElement<?> oldRef = (ComboBoxElement<?>)columnRefList.getSelectedValue();
				JComboBox referenceChooser = (JComboBox)e.getSource();
				ComboBoxElement<?> value = (ComboBoxElement<?>)referenceChooser.getSelectedItem();
				if (value != null) {
					if (!oldRef.toString().equals(value.toString())) {
						/* ---------------------------------------- */
						ComboBoxElement<String> elem = getModel().getColumnReference(
								columnRefList.getSelectedIndex());
						
						elem.setTranslation((String)value.getValue());
						
						getModel().fireTableStructureChanged();
						rearrangeList();
						/* ---------------------------------------- */
					}
				}
				/* ---------------------------------------- */
			}
			/* ======================================== */
		});
		
		optionPanel.appendRow(new NamedComponent(
				Translatrix.getTranslationString("formeditor.referencedComponent"), 
				referenceChooser));
		
		
		// COLUMN NAME FIELD
		JTextField columnNameField = new JTextField(
				referenceElem == null ? "" : (String)referenceElem.getValue());
		columnNameField.setEditable(smthSelected);
		columnNameField.addKeyListener(new KeyListener() {
			/* ======================================== */
			public void keyTyped(KeyEvent e) {}
			public void keyPressed(KeyEvent e) {}
			
			@SuppressWarnings("unchecked")
			public void keyReleased(KeyEvent e) {
				/* ---------------------------------------- */
				ComboBoxElement<String> elem = (ComboBoxElement<String>)
						columnRefList.getSelectedValue();
				JTextField columnNameField = (JTextField)e.getSource();
				elem.setValue(columnNameField.getText());
				
				getModel().setColumnReference(elem, columnRefList.getSelectedIndex());
				((JTable)component).getColumnModel().getColumn(
						columnRefList.getSelectedIndex()).setIdentifier(elem.getValue());
				getModel().fireTableStructureChanged();
				/* ---------------------------------------- */
			}
			/* ======================================== */
		});
		columnNameField.addFocusListener(new FocusListener() {
			
			public void focusLost(FocusEvent e) {
				/* ======================================== */
				ComboBoxElement<?> selectedElem = (ComboBoxElement<?>)columnRefList.getSelectedValue();
				if (selectedElem == null) {
					return;
				}
				
				String listValue = (String) selectedElem.getValue();
				String nameFieldValue = ((JTextField)e.getSource()).getText();
				if ((listValue == null && nameFieldValue != null)
						|| (listValue != null && !listValue.equals(nameFieldValue))) {
					rearrangeList();
				}
				/* ======================================== */
			}
			
			public void focusGained(FocusEvent e) {}
		});
		
		optionPanel.appendRow(new NamedComponent(
				Translatrix.getTranslationString("formeditor.column_name"), 
				columnNameField));
		
		
		// COLUMN REF LIST LISTENER
		columnRefList.addListSelectionListener(new AbstractListener(referenceChooser, columnNameField, 
				addReferenceButton, removeReferenceButton, pushReferenceUpButton, pushReferenceDownButton) {
			public void valueChanged(ListSelectionEvent e) {
				/* ======================================== */
				JComboBox refChooser = (JComboBox)get(0);
				JTextField nameField = (JTextField)get(1);
				
//				JButton addButton = (JButton)get(2);
				JButton removeButton = (JButton)get(3);
				JButton upButton = (JButton)get(4);
				JButton downButton = (JButton)get(5);
				
				int selection = columnRefList.getSelectedIndex();
				if (selection < 0 || selection >= getModel().getColumnCount()) {
					/* ---------------------------------------- */
					refChooser.setSelectedIndex(-1);
					refChooser.setEnabled(false);
					
					nameField.setText("");
					nameField.setEditable(false);
					
					removeButton.setEnabled(false);
					upButton.setEnabled(false);
					downButton.setEnabled(false);
					/* ---------------------------------------- */
				} else {
					/* ---------------------------------------- */
					if (selection == 0) {
						upButton.setEnabled(false);
						downButton.setEnabled(selection != getModel().getColumnCount()-1);
					} else if (selection == getModel().getColumnCount()-1) {
						downButton.setEnabled(false);
						upButton.setEnabled(true);
					} else {
						upButton.setEnabled(true);
						downButton.setEnabled(true);
					}
					
					removeButton.setEnabled(true);
					
					ComboBoxElement<String> elem = getModel().getColumnReference(selection);
					
					nameField.setEditable(true);
					nameField.setText(elem.getValue());
					
					refChooser.setEnabled(true);
					refChooser.setSelectedItem(new ComboBoxElement<String>(
							elem.getTranslation(), elem.getTranslation()));
					
//					fillTable();
					/* ---------------------------------------- */
				}
				/* ======================================== */
			}
		});
		
		return optionPanel;
		/* ======================================== */
	}
	
	public JTable getTable () {
		return (JTable)component;
	}
	
	public EditableDataTableModel getModel() {
		return (EditableDataTableModel) getTable().getModel();
	}
	

	@Override
	public JPanel getAddablePanel(JComponent c) {
		/* ======================================== */
		JScrollPane sp = new JScrollPane(c);
		sp.getVerticalScrollBar().setUnitIncrement(16);
		sp.setOpaque(false);
		sp.setOpaque(false);
		sp.getViewport().setOpaque(false);
		sp.setBorder(BorderFactory.createEmptyBorder());
		return super.getAddablePanel(sp);
		/* ======================================== */
	}

	public void setDatabaseReference (DatabaseReferences dbRef) {
		/* ======================================== */
		if (dbRef != null && dbRef.getTemplate() != null) {
			database = dbRef;
		}
		/* ======================================== */
	}
	
//	private Vector<String> getColumnNameList () {
//		/* ======================================== */
//		Vector<String> columnNames = new Vector<String>();
//		for (int index = 0; index < getModel().getColumnCount(); index++) {
//			/* ---------------------------------------- */
//			String name = getModel().getColumnReference(index).getValue();
//			columnNames.add(name);
//			/* ---------------------------------------- */
//		}
//		return columnNames;
//		/* ======================================== */
//	}
	

	private void rearrangeList () {
		rearrangeList(columnRefList.getSelectedIndex());
	}
	
	private void rearrangeList (int selectIndex) {
		/* ======================================== */
		/* Set a new list model, which actually is the old one.
		 * But changing the old one doesn't changes the view.
		 */
		columnRefList.setModel(new AbstractListModel() {
			/* ======================================== */
			private static final long serialVersionUID = 1L;

			public int getSize() {
				return getModel().getColumnCount();
			}
			
			public Object getElementAt(int index) {
				return getModel().getColumnReference(index);
			}
			/* ======================================== */
		});
		
		columnRefList.setSelectedIndex(selectIndex);
		
		fillTable(false);
		/* ======================================== */
	}

	@Override
	public Boolean isComponentTypeStoredInDBByDefault () {
		return null;
	}
	

	
	
	@Override
	public void saved () {
		fillTable(true);
		
		fireContentReloaded();
	}
	
	
	/**
	 * The reload listener's method contentReloaded() is called when ever the content
	 * of an Component is reloaded and therefore the content has changed.
	 * 
	 * @param listener 
	 * the listener to be added
	 */
	public void addReloadListener (ReloadListener listener) {
		this.reloadListeners.add(listener);
	}
	
	public void removeReloadListener (ReloadListener listener) {
		this.reloadListeners.remove(listener);
	}
	
	public ReloadListener[] getReloadListeners () {
		return this.reloadListeners.toArray(new ReloadListener[0]);
	}
	
	private void fireContentReloaded () {
		final EventObject e = new EventObject(this);
		
		for (final ReloadListener l : this.reloadListeners) {
			new Thread(new Runnable() {
				public void run() {
					l.contentReloaded(e);
				}
			}).run();
		}
	}
}