package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

import lu.tudor.santec.gecamed.formeditor.gui.controller.FormController;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;

public class EditableNumericTextField extends EditableComponent {

	/**
	 * @author Jens Ferring
	 * 
	 * This represents a numeric textField as EditableComponent. It adds a NumericJTextField as component.
	 */
	private static final long serialVersionUID = 1L;
	
	public static final int LISTENER_METHOD_SIZE = 1;
	public static final int CARET_UPDATED = SUPER_LISTENER_METHOD_SIZE;

	public EditableNumericTextField() {
		super();
		this.component = new NumericField("0");
	}
	
	@Override
	public void init (CellConstraints constraints, FormEditorModel model, byte formModelType) {
		super.init(constraints, model, formModelType);
	}
	
	@Override
	protected void initType()
	{
		component.addKeyListener(new KeyListener() 
		{
			public void keyTyped(KeyEvent e) {}
			public void keyPressed(KeyEvent e) {}
			
			public void keyReleased(KeyEvent e) 
			{
				((JTextComponent)optionPanel.getCaptionText()).setText(getText());
			}
		});
		
		super.initType();
	}
	
	
	@Override
	public String getComponentType() {
		return "numericField";
	}

	@Override
	public String getText() {
		return ((NumericField)component).getText();
	}

	@Override
	public void setText(String text) {
		if (text.equals(EditableComponent.MISSING_VALUE)) {
			((NumericField) component).setText(text);
		}
		((NumericField)component).setText(text);
//		((NumericField)component).getValue();
		try {
			// "," is replaced by "." (German decimal separator replaced with English decimal separator)
			text = text.replace(',', '.');
			if (text.equals("")) {
				// default value is 0, if nothing is entered, text = 0
				text = "0";
			} 
			if (text.contains("f")
					|| text.contains("d")
					|| text.contains(" ")) {
				// f, d and space are erased
				throw new NumberFormatException();
			}				
			new Double(text);
			((NumericField)component).setText(text);
		} catch (NumberFormatException e1) {
			try {
				/*
				 * if the new text couldn't be set, try to set the old text, if also the old text couldn't be set
				 * the empty string is set.
				 */
				new Double(((NumericField)component).getText());
			} catch (NumberFormatException e2) {
				((NumericField)component).setText("");
			}
			
			if (model != null) {
				model.getView().rearrangeSettingsPanel();
			}
		}
	}

	@Override
	public NumericField copyComponent(FormModel model) 
	{
		NumericField tf = (NumericField) this.component;
		
		FormController controller = new FormController(model);
		tf.addCaretListener(controller);
		controller.setCodeAt(FormController.CARET_UPDATED, getScriptAt(CARET_UPDATED));
		addDefaultListener(tf, controller);
		
		return tf;
	}

	@Override
	protected void addListenerMethodNames() {
		listenerMethodNames[CARET_UPDATED] = "caretUpdated";
	}

	@Override
	public int getListenerMethodSize() {
		return LISTENER_METHOD_SIZE;
	}

	@Override
	public String getStructure() {
		return "";
	}

	@Override
	public void setStructure(String text) { }

	@Override
	public JComponent createCaptionText () {
		return new NumericField(0);
	}
	
//	@Override
//	public JPanel createOptionPanel (FormEditorModel model) {
//		/* ======================================== */
//		/*
//		 * set / change the text / caption of the component
//		 */
//		
//		CellConstraints cc = new CellConstraints();
//		
//		// define the panel
//		JPanel p = new JPanel(new FormLayout("0px, f:155px, 0px", 
//				"p, p"));
//		p.setOpaque(false);
//		
//		// start value
//		JTextField captionTxt = new NumericField(this.getText());
////		captionTxt.addKeyListener(new ComponentSettingsController(
////				model, ComponentSettingsController.SET_TEXT_FOR_SELECTED_COMPONENT));
//		captionTxt.addKeyListener(new KeyListener() {
//			
//			public void keyTyped(KeyEvent e) {}
//			public void keyPressed(KeyEvent e) {}
//			
//			public void keyReleased(KeyEvent e) {
//				/* ---------------------------------------- */
//				((JTextField)component).setText(((JTextField)e.getSource()).getText());
//				/* ---------------------------------------- */
//			}
//		});
//		p.add(new NamedComponent(Translatrix.getTranslationString(
//		"formeditor.start_value"), captionTxt, true), cc.xy(2, 1));
//		
//		// image icon
//		if (super.iconEnabled) {
//			p.add(getPicPanel(), cc.xy(2, 2));
//		}
//		
//		return p;
//		/* ======================================== */
//	}
	
	@Override
	public String getTypeTranslation () {
		/* ======================================== */
		return Translatrix.getTranslationString("formeditor.add_numeric_textfield");
		/* ======================================== */
	}

	@Override
	public Boolean isComponentTypeStoredInDBByDefault () {
		return true;
	}
}
