package lu.tudor.santec.gecamed.formeditor.gui.component;

import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;
import lu.tudor.santec.gecamed.patient.gui.PermanentlyDisableableToggleButton;
import lu.tudor.santec.i18n.Translatrix;

public class FormToggleButton extends PermanentlyDisableableToggleButton {
	
	private static final long serialVersionUID = 1L;
	
	public FormToggleButton () {}
	
//	public FormToggleButton (Action a) { super(a); }
//	
//	public FormToggleButton (Icon icon) { super(icon); }
//	
//	public FormToggleButton (String text) { super(text); }
//	
//	public FormToggleButton (String text, Icon icon) { super(text, icon); }
//	
//	public FormToggleButton (Icon icon, boolean selected) { super(icon, selected); }
//	
//	public FormToggleButton (String text, boolean selected) { super(text, selected); }
//	
//	public FormToggleButton (String text, Icon icon, boolean selected) { super(text, icon, selected); }
	
	
	
	@Override
	public void setEnabled (boolean enable) {
		if (FormEditorModule.isJavaVersionOK()) {
			super.setEnabled(enable);
		} else {
			super.setEnabled(false);
		}
	}
	
	@Override
	public void setToolTipText (String text) {
		if (!FormEditorModule.isJavaVersionOK())
			super.setToolTipText(
					Translatrix.getTranslationString("formeditor.wrongJavaVersion_tooltipp"));
		else 
			super.setToolTipText(text);
	}
	
	@Override
	public void setMnemonic (int mnemonic) {
		if (FormEditorModule.isJavaVersionOK())
			super.setMnemonic(mnemonic);
	}
	
	@Override
	public void setMnemonic (char mnemonic) {
		if (FormEditorModule.isJavaVersionOK())
			super.setMnemonic(mnemonic);
	}

}
